/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.group.LocalGroup;
import org.wildfly.clustering.server.group.LocalNode;
import org.wildfly.clustering.service.MappedValueService;

public class LocalGroupBuilder
implements CapabilityServiceBuilder<Group> {
    private final ServiceName name;
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();

    public LocalGroupBuilder(ServiceName name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public ServiceBuilder<Group> build(ServiceTarget target) {
        Function<ServerEnvironment, Group> mapper = environment -> new LocalGroup(new LocalNode(environment.getNodeName()));
        return target.addService(this.name, (Service)new MappedValueService(mapper, this.environment)).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.environment).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

