/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.access;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.Ownership;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LockingInterceptor
extends NonTransactionalLockingInterceptor {
    private static final Log log = LogFactory.getLog(LockingInterceptor.class);
    protected final InvocationFinallyAction unlockAllReturnCheckCompletableFutureHandler = new InvocationFinallyAction(){

        public void accept(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable throwable) throws Throwable {
            LockingInterceptor.this.lockManager.unlockAll(rCtx);
            if (rv instanceof CompletableFuture) {
                try {
                    ((CompletableFuture)rv).join();
                }
                catch (CompletionException e) {
                    throw e.getCause();
                }
            }
        }
    };

    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        try {
            if (log.isTraceEnabled()) {
                Ownership ownership = this.cdl.getCacheTopology().getDistribution(command.getKey()).writeOwnership();
                log.tracef("Am I owner for key=%s ? %s", command.getKey(), (Object)ownership);
            }
            if (ctx.getLockOwner() == null) {
                ctx.setLockOwner((Object)command.getCommandInvocationId());
            }
            this.lockAndRecord(ctx, command.getKey(), this.getLockTimeoutMillis((FlagAffectedCommand)command));
        }
        catch (Throwable t) {
            this.lockManager.unlockAll(ctx);
            throw t;
        }
        return this.invokeNextAndFinally(ctx, (VisitableCommand)command, this.unlockAllReturnCheckCompletableFutureHandler);
    }
}

