/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.server.handlers.accesslog.ExtendedAccessLogParser;
import io.undertow.server.handlers.accesslog.JBossLoggingAccessLogReceiver;
import io.undertow.server.handlers.accesslog.LogFileHeaderGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.IoUtils;
import org.xnio.XnioWorker;

class AccessLogService
implements Service<AccessLogService> {
    private final InjectedValue<Host> host = new InjectedValue();
    protected final InjectedValue<XnioWorker> worker = new InjectedValue();
    private final String pattern;
    private final String path;
    private final String pathRelativeTo;
    private final String filePrefix;
    private final String fileSuffix;
    private final boolean rotate;
    private final boolean useServerLog;
    private final boolean extended;
    private final Predicate predicate;
    private volatile AccessLogReceiver logReceiver;
    private PathManager.Callback.Handle callbackHandle;
    private Path directory;
    private ExchangeAttribute extendedPattern;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();

    AccessLogService(String pattern, boolean extended, Predicate predicate) {
        this.pattern = pattern;
        this.extended = extended;
        this.path = null;
        this.pathRelativeTo = null;
        this.filePrefix = null;
        this.fileSuffix = null;
        this.useServerLog = true;
        this.rotate = false;
        this.predicate = predicate == null ? Predicates.truePredicate() : predicate;
    }

    AccessLogService(String pattern, String path, String pathRelativeTo, String filePrefix, String fileSuffix, boolean rotate, boolean extended, Predicate predicate) {
        this.pattern = pattern;
        this.path = path;
        this.pathRelativeTo = pathRelativeTo;
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
        this.rotate = rotate;
        this.extended = extended;
        this.useServerLog = false;
        this.predicate = predicate == null ? Predicates.truePredicate() : predicate;
    }

    public void start(StartContext context) throws StartException {
        if (this.useServerLog) {
            this.logReceiver = new JBossLoggingAccessLogReceiver();
        } else {
            if (this.pathRelativeTo != null) {
                this.callbackHandle = ((PathManager)this.pathManager.getValue()).registerCallback(this.pathRelativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
            }
            this.directory = Paths.get(((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(this.path, this.pathRelativeTo), new String[0]);
            if (!Files.exists(this.directory, new LinkOption[0])) {
                try {
                    Files.createDirectories(this.directory, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw UndertowLogger.ROOT_LOGGER.couldNotCreateLogDirectory(this.directory, e);
                }
            }
            try {
                DefaultAccessLogReceiver.Builder builder = DefaultAccessLogReceiver.builder().setLogWriteExecutor((Executor)this.worker.getValue()).setOutputDirectory(this.directory).setLogBaseName(this.filePrefix).setLogNameSuffix(this.fileSuffix).setRotate(this.rotate);
                if (this.extended) {
                    builder.setLogFileHeaderGenerator((LogFileHeaderGenerator)new ExtendedAccessLogParser.ExtendedAccessLogHeaderGenerator(this.pattern));
                    this.extendedPattern = new ExtendedAccessLogParser(this.getClass().getClassLoader()).parse(this.pattern);
                } else {
                    this.extendedPattern = null;
                }
                this.logReceiver = builder.build();
            }
            catch (IllegalStateException e) {
                throw new StartException((Throwable)e);
            }
        }
        ((Host)this.host.getValue()).setAccessLogService(this);
    }

    public void stop(StopContext context) {
        ((Host)this.host.getValue()).setAccessLogService(null);
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
            this.callbackHandle = null;
        }
        if (this.logReceiver instanceof DefaultAccessLogReceiver) {
            IoUtils.safeClose((Closeable)((DefaultAccessLogReceiver)this.logReceiver));
        }
        this.logReceiver = null;
    }

    public AccessLogService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    InjectedValue<XnioWorker> getWorker() {
        return this.worker;
    }

    InjectedValue<PathManager> getPathManager() {
        return this.pathManager;
    }

    protected AccessLogHandler configureAccessLogHandler(HttpHandler handler) {
        if (this.extendedPattern != null) {
            return new AccessLogHandler(handler, this.logReceiver, this.pattern, this.extendedPattern, this.predicate);
        }
        return new AccessLogHandler(handler, this.logReceiver, this.pattern, this.getClass().getClassLoader(), this.predicate);
    }

    public InjectedValue<Host> getHost() {
        return this.host;
    }

    boolean isRotate() {
        return this.rotate;
    }

    String getPath() {
        return this.path;
    }
}

