/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import javax.ejb.SessionBean;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.session.SessionBeanSetSessionContextMethodInvocationInterceptor;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;

public class SessionBeanMergingProcessor
extends AbstractMergingProcessor<SessionBeanComponentDescription> {
    public SessionBeanMergingProcessor() {
        super(SessionBeanComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SessionBeanComponentDescription description) throws DeploymentUnitProcessingException {
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SessionBeanComponentDescription description) throws DeploymentUnitProcessingException {
        if (SessionBean.class.isAssignableFrom(componentClass)) {
            description.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    if (SessionBean.class.isAssignableFrom(configuration.getComponentClass())) {
                        configuration.addPostConstructInterceptor(SessionBeanSetSessionContextMethodInvocationInterceptor.FACTORY, 3072);
                    }
                }
            });
            MethodIdentifier ejbRemoveIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)"ejbRemove", (Class[])new Class[0]);
            MethodIdentifier ejbActivateIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)"ejbActivate", (Class[])new Class[0]);
            MethodIdentifier ejbPassivateIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)"ejbPassivate", (Class[])new Class[0]);
            boolean ejbActivate = false;
            boolean ejbPassivate = false;
            boolean ejbRemove = false;
            for (Class<?> c = componentClass; c != null && c != Object.class; c = c.getSuperclass()) {
                InterceptorClassDescription.Builder builder;
                Method method;
                ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(c);
                if (!ejbActivate && (method = index.getMethod(ejbActivateIdentifier)) != null) {
                    builder = InterceptorClassDescription.builder();
                    builder.setPostActivate(ejbActivateIdentifier);
                    description.addInterceptorMethodOverride(c.getName(), builder.build());
                    ejbActivate = true;
                }
                if (!ejbPassivate && (method = index.getMethod(ejbPassivateIdentifier)) != null) {
                    builder = InterceptorClassDescription.builder();
                    builder.setPrePassivate(ejbPassivateIdentifier);
                    description.addInterceptorMethodOverride(c.getName(), builder.build());
                    ejbPassivate = true;
                }
                if (ejbRemove || (method = index.getMethod(ejbRemoveIdentifier)) == null) continue;
                builder = InterceptorClassDescription.builder();
                builder.setPreDestroy(ejbRemoveIdentifier);
                description.addInterceptorMethodOverride(c.getName(), builder.build());
                ejbRemove = true;
            }
        }
    }
}

