/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractProtocolConfigurationBuilder<P extends Protocol, C extends ProtocolConfiguration<P>>
implements ResourceServiceBuilder<C>,
Value<C>,
ProtocolConfiguration<P>,
Consumer<P> {
    private final String name;
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final InjectedValue<ProtocolDefaults> defaults = new InjectedValue();
    private final Map<String, String> properties = new HashMap<String, String>();
    private volatile String moduleName;
    private volatile Boolean statisticsEnabled;

    protected AbstractProtocolConfigurationBuilder(String name) {
        this.name = name;
    }

    public ServiceBuilder<C> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).addDependency(ProtocolDefaultsBuilder.SERVICE_NAME, ProtocolDefaults.class, this.defaults).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Builder<C> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.properties.clear();
        for (Property property : ModelNodes.optionalPropertyList((ModelNode)AbstractProtocolResourceDefinition.Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model)).orElse(Collections.emptyList())) {
            this.properties.put(property.getName(), property.getValue().asString());
        }
        this.statisticsEnabled = AbstractProtocolResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBooleanOrNull();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public final P createProtocol(ProtocolStackConfiguration stackConfiguration) {
        boolean nativeProtocol = this.moduleName.equals(AbstractProtocolResourceDefinition.Attribute.MODULE.getDefinition().getDefaultValue().asString()) && !this.name.startsWith("org.jgroups.protocols");
        String className = nativeProtocol ? String.join((CharSequence)".", "org.jgroups.protocols", this.name) : this.name;
        try {
            Module module = ((ModuleLoader)this.loader.getValue()).loadModule(this.moduleName);
            Class<Protocol> protocolClass = module.getClassLoader().loadClass(className).asSubclass(Protocol.class);
            HashMap<String, String> properties = new HashMap<String, String>(((ProtocolDefaults)this.defaults.getValue()).getProperties(protocolClass));
            properties.putAll(this.properties);
            PrivilegedExceptionAction<Protocol> action = () -> {
                try {
                    return ((Protocol)protocolClass.newInstance()).setProperties(properties);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException(e);
                }
            };
            Protocol protocol = (Protocol)WildFlySecurityManager.doUnchecked(action);
            this.accept(protocol);
            protocol.enableStats(this.statisticsEnabled != null ? this.statisticsEnabled.booleanValue() : stackConfiguration.isStatisticsEnabled());
            return (P)protocol;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

