/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.container;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.GroupCommand;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.container.CommandContainerBuilder;
import org.aesh.command.impl.activator.AeshCommandActivatorProvider;
import org.aesh.command.impl.activator.AeshOptionActivatorProvider;
import org.aesh.command.impl.completer.AeshCompleterInvocationProvider;
import org.aesh.command.impl.container.AeshCommandContainer;
import org.aesh.command.impl.converter.AeshConverterInvocationProvider;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedCommandBuilder;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.impl.invocation.AeshInvocationProviders;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.impl.parser.CommandLineParserBuilder;
import org.aesh.command.impl.validator.AeshValidatorInvocationProvider;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionGroup;
import org.aesh.command.option.OptionList;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.util.ReflectionUtil;

public class AeshCommandContainerBuilder<C extends Command<CI>, CI extends CommandInvocation>
implements CommandContainerBuilder<C, CI> {
    @Override
    public CommandContainer<C, CI> create(C command) throws CommandLineParserException {
        return this.doGenerateCommandLineParser(command);
    }

    @Override
    public CommandContainer<C, CI> create(Class<C> command) throws CommandLineParserException {
        return this.doGenerateCommandLineParser((Command)ReflectionUtil.newInstance(command));
    }

    private AeshCommandContainer<C, CI> doGenerateCommandLineParser(C commandObject) throws CommandLineParserException {
        Class<?> clazz = commandObject.getClass();
        CommandDefinition command = clazz.getAnnotation(CommandDefinition.class);
        if (command != null) {
            ProcessedCommand processedCommand = new ProcessedCommandBuilder().name(command.name()).activator(command.activator()).aliases(Arrays.asList(command.aliases())).description(command.description()).validator(command.validator()).command(commandObject).resultHandler(command.resultHandler()).create();
            AeshCommandContainerBuilder.processCommand(processedCommand, clazz);
            return new AeshCommandContainer(new CommandLineParserBuilder().processedCommand(processedCommand).create());
        }
        GroupCommandDefinition groupCommand = clazz.getAnnotation(GroupCommandDefinition.class);
        if (groupCommand != null) {
            ProcessedCommand processedGroupCommand = new ProcessedCommandBuilder().name(groupCommand.name()).activator(groupCommand.activator()).aliases(Arrays.asList(groupCommand.aliases())).description(groupCommand.description()).validator(groupCommand.validator()).command(commandObject).resultHandler(groupCommand.resultHandler()).create();
            AeshCommandContainerBuilder.processCommand(processedGroupCommand, clazz);
            AeshCommandContainer<Command, CI> groupContainer = new AeshCommandContainer<Command, CI>(new CommandLineParserBuilder().processedCommand(processedGroupCommand).create());
            if (commandObject instanceof GroupCommand) {
                List commands = ((GroupCommand)commandObject).getCommands();
                if (commands != null) {
                    for (Command sub : commands) {
                        groupContainer.addChild(this.doGenerateCommandLineParser(sub));
                    }
                }
            } else {
                for (Class<? extends Command> groupClazz : groupCommand.groupCommands()) {
                    Command groupInstance = ReflectionUtil.newInstance(groupClazz);
                    groupContainer.addChild(this.doGenerateCommandLineParser(groupInstance));
                }
            }
            return groupContainer;
        }
        throw new CommandLineParserException("Commands must be annotated with @CommandDefinition or @GroupCommandDefinition");
    }

    private static void processCommand(ProcessedCommand processedCommand, Class clazz) throws CommandLineParserException {
        for (Field field : clazz.getDeclaredFields()) {
            AeshCommandContainerBuilder.processField(processedCommand, field);
        }
        if (clazz.getSuperclass() != null) {
            AeshCommandContainerBuilder.processCommand(processedCommand, clazz.getSuperclass());
        }
    }

    private static void processField(ProcessedCommand processedCommand, Field field) throws CommandLineParserException {
        Option o = field.getAnnotation(Option.class);
        if (o != null) {
            OptionType optionType = o.hasValue() ? OptionType.NORMAL : OptionType.BOOLEAN;
            processedCommand.addOption(ProcessedOptionBuilder.builder().shortName(o.shortName()).name(o.name().length() < 1 ? field.getName() : o.name()).description(o.description()).required(o.required()).valueSeparator(',').addAllDefaultValues(o.defaultValue()).type(field.getType()).fieldName(field.getName()).optionType(optionType).converter(o.converter()).completer(o.completer()).validator(o.validator()).activator(o.activator()).renderer(o.renderer()).parser(o.parser()).overrideRequired(o.overrideRequired()).build());
        } else {
            OptionList ol = field.getAnnotation(OptionList.class);
            if (ol != null) {
                if (!Collection.class.isAssignableFrom(field.getType())) {
                    throw new CommandLineParserException("OptionList field must be instance of Collection");
                }
                Class type = Object.class;
                if (field.getGenericType() != null) {
                    ParameterizedType listType = (ParameterizedType)field.getGenericType();
                    type = (Class)listType.getActualTypeArguments()[0];
                }
                processedCommand.addOption(ProcessedOptionBuilder.builder().shortName(ol.shortName()).name(ol.name().length() < 1 ? field.getName() : ol.name()).description(ol.description()).required(ol.required()).valueSeparator(ol.valueSeparator()).addAllDefaultValues(ol.defaultValue()).type(type).fieldName(field.getName()).optionType(OptionType.LIST).converter(ol.converter()).completer(ol.completer()).validator(ol.validator()).activator(ol.activator()).renderer(ol.renderer()).parser(ol.parser()).build());
            } else {
                OptionGroup og = field.getAnnotation(OptionGroup.class);
                if (og != null) {
                    if (!Map.class.isAssignableFrom(field.getType())) {
                        throw new CommandLineParserException("OptionGroup field must be instance of Map");
                    }
                    Class type = Object.class;
                    if (field.getGenericType() != null) {
                        ParameterizedType listType = (ParameterizedType)field.getGenericType();
                        type = (Class)listType.getActualTypeArguments()[1];
                    }
                    processedCommand.addOption(ProcessedOptionBuilder.builder().shortName(og.shortName()).name(og.name().length() < 1 ? field.getName() : og.name()).description(og.description()).required(og.required()).valueSeparator(',').addAllDefaultValues(og.defaultValue()).type(type).fieldName(field.getName()).optionType(OptionType.GROUP).converter(og.converter()).completer(og.completer()).validator(og.validator()).activator(og.activator()).renderer(og.renderer()).parser(og.parser()).build());
                } else {
                    Arguments a = field.getAnnotation(Arguments.class);
                    if (a != null) {
                        if (!Collection.class.isAssignableFrom(field.getType())) {
                            throw new CommandLineParserException("Arguments field must be instance of Collection");
                        }
                        if (processedCommand.getArgument() != null) {
                            throw new CommandLineParserException("Arguments can not be defined with an Argument type");
                        }
                        Class type = Object.class;
                        if (field.getGenericType() != null) {
                            ParameterizedType listType = (ParameterizedType)field.getGenericType();
                            type = (Class)listType.getActualTypeArguments()[0];
                        }
                        processedCommand.setArguments(ProcessedOptionBuilder.builder().shortName('\u0000').name("").description(a.description()).required(a.required()).valueSeparator(a.valueSeparator()).addAllDefaultValues(a.defaultValue()).type(type).fieldName(field.getName()).optionType(OptionType.ARGUMENTS).converter(a.converter()).completer(a.completer()).validator(a.validator()).activator(a.activator()).parser(a.parser()).build());
                    } else {
                        Argument arg = field.getAnnotation(Argument.class);
                        if (arg != null) {
                            if (processedCommand.getArgument() != null) {
                                throw new CommandLineParserException("Argument can not be defined more than once pr class");
                            }
                            if (processedCommand.getArguments() != null) {
                                throw new CommandLineParserException("Argument can not be defined with an Arguments type");
                            }
                            if (Collection.class.isAssignableFrom(field.getType())) {
                                throw new CommandLineParserException("Argument field can not be an instance of Collection");
                            }
                            OptionType optionType = OptionType.ARGUMENT;
                            processedCommand.setArgument(ProcessedOptionBuilder.builder().shortName('\u0000').name("").description(arg.description()).required(arg.required()).valueSeparator(',').addAllDefaultValues(arg.defaultValue()).type(field.getType()).fieldName(field.getName()).optionType(optionType).converter(arg.converter()).completer(arg.completer()).validator(arg.validator()).activator(arg.activator()).renderer(arg.renderer()).parser(arg.parser()).overrideRequired(arg.overrideRequired()).build());
                        }
                    }
                }
            }
        }
    }

    public static void parseAndPopulate(Command<CommandInvocation> instance, String input) throws CommandLineParserException, OptionValidatorException {
        AeshCommandContainerBuilder builder = new AeshCommandContainerBuilder();
        CommandLineParser<Command<CommandInvocation>> cl = super.doGenerateCommandLineParser(instance).getParser();
        AeshInvocationProviders invocationProviders = new AeshInvocationProviders(new AeshConverterInvocationProvider(), new AeshCompleterInvocationProvider(), new AeshValidatorInvocationProvider(), new AeshOptionActivatorProvider(), new AeshCommandActivatorProvider());
        cl.parse(input);
        cl.getCommandPopulator().populateObject(cl.getProcessedCommand(), invocationProviders, null, CommandLineParser.Mode.VALIDATE);
    }
}

