/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.parser;

import java.util.ArrayList;
import java.util.List;
import org.aesh.command.operator.OperatorType;
import org.aesh.parser.ParsedLineIterator;
import org.aesh.parser.ParsedWord;
import org.aesh.parser.ParserStatus;

public class ParsedLine {
    private final String originalInput;
    private final String errorMessage;
    private final List<ParsedWord> words;
    private final ParserStatus status;
    private final int cursor;
    private final int cursorWord;
    private final int wordCursor;
    private final OperatorType operator;

    public ParsedLine(String originalInput, List<ParsedWord> words, int cursor, int cursorWord, int wordCursor, ParserStatus status, String errorMessage, OperatorType operator) {
        this.originalInput = originalInput;
        this.cursor = cursor;
        this.cursorWord = cursorWord;
        this.wordCursor = wordCursor;
        this.status = status;
        this.errorMessage = errorMessage;
        this.operator = operator;
        if (words == null) {
            this.words = new ArrayList<ParsedWord>(0);
            return;
        }
        this.words = words;
    }

    public int cursor() {
        return this.cursor;
    }

    public int selectedIndex() {
        return this.cursorWord;
    }

    public ParsedWord selectedWord() {
        if (this.cursorWord > -1 && this.cursorWord < this.words.size()) {
            return this.words.get(this.cursorWord);
        }
        return new ParsedWord("", 0);
    }

    public ParsedWord selectedWordToCursor() {
        if (this.cursorWord > -1 && this.cursorWord < this.words.size()) {
            return new ParsedWord(this.words.get(this.cursorWord).word().substring(0, this.wordCursor), this.words.get(this.cursorWord).lineIndex());
        }
        return new ParsedWord("", 0);
    }

    public int wordCursor() {
        return this.wordCursor;
    }

    public String line() {
        return this.originalInput;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<ParsedWord> words() {
        return this.words;
    }

    public ParserStatus status() {
        return this.status;
    }

    public ParsedWord lastWord() {
        return this.words().get(this.words.size() - 1);
    }

    public int size() {
        return this.words().size();
    }

    public ParsedLineIterator iterator() {
        return new ParsedLineIterator(this);
    }

    public OperatorType operator() {
        return this.operator;
    }

    public boolean cursorAtEnd() {
        return this.cursor == this.originalInput.length();
    }

    public boolean spaceAtEnd() {
        if (this.originalInput.length() > 1) {
            return this.originalInput.charAt(this.originalInput.length() - 1) == ' ' && this.originalInput.charAt(this.originalInput.length() - 2) != '\\';
        }
        return this.originalInput.length() > 0 && this.originalInput.charAt(this.originalInput.length() - 1) == ' ';
    }

    public String toString() {
        return "ParsedLine{originalInput='" + this.originalInput + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", words=" + this.words + ", status=" + (Object)((Object)this.status) + ", cursor=" + this.cursor + ", cursorWord=" + this.cursorWord + ", wordCursor=" + this.wordCursor + ", operator=" + (Object)((Object)this.operator) + '}';
    }
}

