/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.Collections;
import java.util.Set;
import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.DependencySpecBuilder;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoaderDependency;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public final class LocalDependencySpecBuilder
extends DependencySpecBuilder {
    private LocalLoader localLoader;
    private Set<String> loaderPaths = Collections.emptySet();

    public LocalDependencySpecBuilder() {
        this.setImportFilter(PathFilters.acceptAll());
    }

    @Override
    public PathFilter getImportFilter() {
        return super.getImportFilter();
    }

    @Override
    public LocalDependencySpecBuilder setImportFilter(PathFilter importFilter) {
        super.setImportFilter(importFilter);
        return this;
    }

    @Override
    public LocalDependencySpecBuilder setImportServices(boolean services) {
        super.setImportServices(services);
        return this;
    }

    @Override
    public LocalDependencySpecBuilder setExportFilter(PathFilter exportFilter) {
        super.setExportFilter(exportFilter);
        return this;
    }

    @Override
    public LocalDependencySpecBuilder setExport(boolean export) {
        super.setExport(export);
        return this;
    }

    @Override
    public LocalDependencySpecBuilder setResourceImportFilter(PathFilter resourceImportFilter) {
        super.setResourceImportFilter(resourceImportFilter);
        return this;
    }

    @Override
    public LocalDependencySpecBuilder setResourceExportFilter(PathFilter resourceExportFilter) {
        super.setResourceExportFilter(resourceExportFilter);
        return this;
    }

    @Override
    public LocalDependencySpecBuilder setClassImportFilter(ClassFilter classImportFilter) {
        super.setClassImportFilter(classImportFilter);
        return this;
    }

    @Override
    public LocalDependencySpecBuilder setClassExportFilter(ClassFilter classExportFilter) {
        super.setClassExportFilter(classExportFilter);
        return this;
    }

    public LocalLoader getLocalLoader() {
        return this.localLoader;
    }

    public LocalDependencySpecBuilder setLocalLoader(LocalLoader localLoader) {
        if (localLoader == null) {
            throw new IllegalArgumentException("localLoader is null");
        }
        this.localLoader = localLoader;
        return this;
    }

    public Set<String> getLoaderPaths() {
        return this.loaderPaths;
    }

    public LocalDependencySpecBuilder setLoaderPaths(Set<String> loaderPaths) {
        if (loaderPaths == null) {
            throw new IllegalArgumentException("loaderPaths is null");
        }
        this.loaderPaths = loaderPaths;
        return this;
    }

    @Override
    public DependencySpec build() {
        final LocalLoader localLoader = this.localLoader;
        final Set<String> loaderPaths = this.loaderPaths;
        if (localLoader == null) {
            return new DependencySpec(this.importFilter, this.exportFilter, this.resourceImportFilter, this.resourceExportFilter, this.classImportFilter, this.classExportFilter){

                @Override
                Dependency getDependency(Module module) {
                    return new ModuleClassLoaderDependency(this.getExportFilter(), this.getImportFilter(), this.getResourceExportFilter(), this.getResourceImportFilter(), this.getClassExportFilter(), this.getClassImportFilter(), module.getClassLoaderPrivate());
                }

                public String toString() {
                    return "dependency on local resources";
                }
            };
        }
        return new DependencySpec(this.importFilter, this.exportFilter, this.resourceImportFilter, this.resourceExportFilter, this.classImportFilter, this.classExportFilter){

            @Override
            Dependency getDependency(Module module) {
                return new LocalDependency(this.getExportFilter(), this.getImportFilter(), this.getResourceExportFilter(), this.getResourceImportFilter(), this.getClassExportFilter(), this.getClassImportFilter(), localLoader, loaderPaths);
            }

            public String toString() {
                return "dependency on local loader " + localLoader;
            }
        };
    }
}

