/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.sp;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.IdentityURLProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.bindings.wildfly.sp.SecurityActions;
import org.picketlink.identity.federation.web.config.IdentityURLConfigurationProvider;
import org.picketlink.identity.federation.web.config.PropertiesIdentityURLProvider;

public class IdentityURLProviderHandler
implements HttpHandler {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String ACCOUNT_CHOOSER_COOKIE_NAME = "picketlink.account.name";
    public static final String ACCOUNT_PARAMETER = "idp";
    public static final String AUTHENTICATING = "AUTHENTICATING";
    public static final String STATE = "STATE";
    private final HttpHandler next;
    private final SPType spType;
    private final IdentityURLConfigurationProvider identityURLConfigurationProvider;
    private final Map<String, String> idpMap = new ConcurrentHashMap<String, String>();

    public static final HandlerWrapper wrapper(final SPType spType, final ServletContext servletContext) {
        return new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler next) {
                return new IdentityURLProviderHandler(spType, servletContext, next);
            }
        };
    }

    public IdentityURLProviderHandler(SPType spType, ServletContext servletContext, HttpHandler next) {
        this.spType = spType;
        this.next = next;
        IdentityURLProviderType identityURLProvider = spType.getIdentityURLProvider();
        if (identityURLProvider == null) {
            throw logger.nullArgumentError("IdentityURL Provider");
        }
        try {
            Class<?> clazz;
            String type = identityURLProvider.getType();
            if (type == null) {
                type = PropertiesIdentityURLProvider.class.getName();
            }
            if ((clazz = SecurityActions.loadClass(this.getClass(), type)) == null) {
                throw logger.classNotLoadedError(type);
            }
            this.identityURLConfigurationProvider = (IdentityURLConfigurationProvider)clazz.newInstance();
            this.identityURLConfigurationProvider.setServletContext(servletContext);
            this.idpMap.putAll(this.identityURLConfigurationProvider.getIDPMap());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Identity URL provider [" + this.getClass().getName() + "].", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        HttpSession session = request.getSession();
        if (this.idpMap.isEmpty()) {
            this.idpMap.putAll(this.identityURLConfigurationProvider.getIDPMap());
        }
        String sessionState = (String)session.getAttribute(STATE);
        String idpChosenKey = request.getParameter(ACCOUNT_PARAMETER);
        String cookieValue = this.cookieValue(request);
        if (cookieValue != null || AUTHENTICATING.equals(sessionState)) {
            if (idpChosenKey != null) {
                String chosenIDP = this.idpMap.get(idpChosenKey);
                request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
            }
            if (AUTHENTICATING.equals(sessionState) && request.getParameter("SAMLResponse") == null) {
                session.removeAttribute(STATE);
                this.redirectToChosenPage(request, response);
                return;
            }
            this.proceedToAuthentication(exchange, cookieValue);
            return;
        }
        if (idpChosenKey == null) {
            this.redirectToChosenPage(request, response);
            exchange.endExchange();
            return;
        }
        String chosenIDP = this.idpMap.get(idpChosenKey);
        if (chosenIDP != null) {
            request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
            session.setAttribute(STATE, (Object)AUTHENTICATING);
            this.proceedToAuthentication(exchange, idpChosenKey);
            return;
        }
        logger.configurationFileMissing(":IDP Mapping");
        throw new ServletException();
    }

    protected String cookieValue(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieValue;
                String chosenIDP;
                String cookieName = cookie.getName();
                String cookieDomain = cookie.getDomain();
                if (cookieDomain != null && cookieDomain.equalsIgnoreCase(this.getIdentityURLProvider().getDomain())) {
                    if (!ACCOUNT_CHOOSER_COOKIE_NAME.equals(cookieName) || (chosenIDP = this.idpMap.get(cookieValue = cookie.getValue())) == null) continue;
                    request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
                    return cookieValue;
                }
                if (!ACCOUNT_CHOOSER_COOKIE_NAME.equals(cookieName) || (chosenIDP = this.idpMap.get(cookieValue = cookie.getValue())) == null) continue;
                request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
                return cookieValue;
            }
        }
        return null;
    }

    protected void redirectToChosenPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext servletContext;
        RequestDispatcher requestDispatcher;
        String page = this.getIdentityURLProvider().getPage();
        if (page == null) {
            page = "/accountChooser.html";
        }
        if ((requestDispatcher = (servletContext = request.getServletContext()).getRequestDispatcher(page)) != null) {
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedToAuthentication(HttpServerExchange exchange, String cookieValue) throws Exception {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        HttpSession session = request.getSession(true);
        String state = session != null ? (String)session.getAttribute(STATE) : null;
        try {
            this.next.handleRequest(exchange);
        }
        finally {
            if (request.getUserPrincipal() != null && StringUtil.isNotNull((String)state)) {
                session.removeAttribute(STATE);
                ServletContext servletContext = request.getServletContext();
                String contextpath = servletContext.getContextPath();
                if (cookieValue == null) {
                    cookieValue = request.getParameter(ACCOUNT_PARAMETER);
                }
                Cookie cookie = new Cookie(ACCOUNT_CHOOSER_COOKIE_NAME, cookieValue);
                cookie.setPath(contextpath);
                IdentityURLProviderType identityURLProvider = this.getIdentityURLProvider();
                cookie.setMaxAge(identityURLProvider.getExpiration());
                String domain = identityURLProvider.getDomain();
                if (domain != null) {
                    cookie.setDomain(domain);
                }
                response.addCookie(cookie);
            }
        }
    }

    private IdentityURLProviderType getIdentityURLProvider() {
        return this.spType.getIdentityURLProvider();
    }
}

