/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.controller.transform.OperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.NoTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class CacheContainerResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    static final PathElement WILDCARD_PATH = CacheContainerResourceDefinition.pathElement("*");
    static final Map<InfinispanCacheRequirement, org.jboss.as.clustering.controller.Capability> DEFAULT_CAPABILITIES = new EnumMap<InfinispanCacheRequirement, org.jboss.as.clustering.controller.Capability>(InfinispanCacheRequirement.class);
    static final Map<ClusteringCacheRequirement, org.jboss.as.clustering.controller.Capability> DEFAULT_CLUSTERING_CAPABILITIES;
    @Deprecated
    static final AttributeDefinition ALIAS;
    @Deprecated
    static final OperationDefinition ALIAS_ADD;
    @Deprecated
    static final OperationDefinition ALIAS_REMOVE;

    static PathElement pathElement(String containerName) {
        return PathElement.pathElement((String)"cache-container", (String)containerName);
    }

    static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type) {
        return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            for (ThreadPoolResourceDefinition threadPoolResourceDefinition : EnumSet.complementOf(EnumSet.of(ThreadPoolResourceDefinition.CLIENT))) {
                builder.addChildResource(threadPoolResourceDefinition.getPathElement(), threadPoolResourceDefinition.getDiscardPolicy());
            }
            for (ScheduledThreadPoolResourceDefinition scheduledThreadPoolResourceDefinition : EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class)) {
                builder.addChildResource(scheduledThreadPoolResourceDefinition.getPathElement(), scheduledThreadPoolResourceDefinition.getDiscardPolicy());
            }
        } else {
            for (ThreadPoolResourceDefinition threadPoolResourceDefinition : EnumSet.complementOf(EnumSet.of(ThreadPoolResourceDefinition.CLIENT))) {
                threadPoolResourceDefinition.buildTransformation(version, parent);
            }
            for (ScheduledThreadPoolResourceDefinition scheduledThreadPoolResourceDefinition : EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class)) {
                scheduledThreadPoolResourceDefinition.buildTransformation(version, parent);
            }
        }
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            OperationTransformer addAliasTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    String attributeName = Operations.getAttributeName((ModelNode)operation);
                    if (Attribute.ALIASES.getName().equals(attributeName)) {
                        ModelNode value = Operations.getAttributeValue((ModelNode)operation);
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        ModelNode transformedOperation = Util.createOperation((OperationDefinition)ALIAS_ADD, (PathAddress)address);
                        transformedOperation.get(ALIAS.getName()).set(value);
                        return transformedOperation;
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride(ListOperations.LIST_ADD_DEFINITION.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(addAliasTransformer));
            OperationTransformer operationTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    String attributeName = Operations.getAttributeName((ModelNode)operation);
                    if (Attribute.ALIASES.getName().equals(attributeName)) {
                        ModelNode value = Operations.getAttributeValue((ModelNode)operation);
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        ModelNode transformedOperation = Util.createOperation((OperationDefinition)ALIAS_REMOVE, (PathAddress)address);
                        transformedOperation.get(ALIAS.getName()).set(value);
                        return transformedOperation;
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride(ListOperations.LIST_REMOVE_DEFINITION.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(operationTransformer));
        }
        NoTransportResourceDefinition.buildTransformation(version, builder);
        JGroupsTransportResourceDefinition.buildTransformation(version, builder);
        ScatteredCacheResourceDefinition.buildTransformation(version, builder);
        DistributedCacheResourceDefinition.buildTransformation(version, builder);
        ReplicatedCacheResourceDefinition.buildTransformation(version, builder);
        InvalidationCacheResourceDefinition.buildTransformation(version, builder);
        LocalCacheResourceDefinition.buildTransformation(version, builder);
    }

    CacheContainerResourceDefinition() {
        super(WILDCARD_PATH, InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{WILDCARD_PATH}));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addAttributes(ExecutorAttribute.class).addAttributes(DeprecatedAttribute.class).addCapabilities(Capability.class).addCapabilities(model -> model.hasDefined(Attribute.DEFAULT_CACHE.getName()), DEFAULT_CAPABILITIES.values()).addCapabilities(model -> model.hasDefined(Attribute.DEFAULT_CACHE.getName()), DEFAULT_CLUSTERING_CAPABILITIES.values()).addRequiredChildren(EnumSet.complementOf(EnumSet.of(ThreadPoolResourceDefinition.CLIENT))).addRequiredChildren(ScheduledThreadPoolResourceDefinition.class).addRequiredSingletonChildren(new PathElement[]{NoTransportResourceDefinition.PATH});
        CacheContainerServiceHandler handler = new CacheContainerServiceHandler();
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        OperationStepHandler addAliasHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode legacyOperation) {
                String value = legacyOperation.get(ALIAS.getName()).asString();
                ModelNode operation = Operations.createListAddOperation((PathAddress)context.getCurrentAddress(), (org.jboss.as.clustering.controller.Attribute)Attribute.ALIASES, (String)value);
                context.addStep(operation, ListOperations.LIST_ADD_HANDLER, context.getCurrentStage());
            }
        };
        registration.registerOperationHandler(ALIAS_ADD, addAliasHandler);
        OperationStepHandler removeAliasHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode legacyOperation) throws OperationFailedException {
                String value = legacyOperation.get(ALIAS.getName()).asString();
                ModelNode operation = Operations.createListRemoveOperation((PathAddress)context.getCurrentAddress(), (org.jboss.as.clustering.controller.Attribute)Attribute.ALIASES, (String)value);
                context.addStep(operation, ListOperations.LIST_REMOVE_HANDLER, context.getCurrentStage());
            }
        };
        registration.registerOperationHandler(ALIAS_REMOVE, removeAliasHandler);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new MetricHandler((MetricExecutor)new CacheContainerMetricExecutor(), CacheContainerMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        new JGroupsTransportResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new NoTransportResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        for (ThreadPoolResourceDefinition threadPoolResourceDefinition : EnumSet.complementOf(EnumSet.of(ThreadPoolResourceDefinition.CLIENT))) {
            threadPoolResourceDefinition.register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        for (ScheduledThreadPoolResourceDefinition scheduledThreadPoolResourceDefinition : EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class)) {
            scheduledThreadPoolResourceDefinition.register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        new LocalCacheResourceDefinition().register(registration);
        new InvalidationCacheResourceDefinition().register(registration);
        new ReplicatedCacheResourceDefinition().register(registration);
        new DistributedCacheResourceDefinition().register(registration);
        new ScatteredCacheResourceDefinition().register(registration);
        return registration;
    }

    static {
        for (InfinispanCacheRequirement infinispanCacheRequirement : EnumSet.allOf(InfinispanCacheRequirement.class)) {
            DEFAULT_CAPABILITIES.put(infinispanCacheRequirement, (org.jboss.as.clustering.controller.Capability)new UnaryRequirementCapability(infinispanCacheRequirement.getDefaultRequirement()));
        }
        DEFAULT_CLUSTERING_CAPABILITIES = new EnumMap<ClusteringCacheRequirement, org.jboss.as.clustering.controller.Capability>(ClusteringCacheRequirement.class);
        for (ClusteringCacheRequirement clusteringCacheRequirement : EnumSet.allOf(ClusteringCacheRequirement.class)) {
            DEFAULT_CLUSTERING_CAPABILITIES.put(clusteringCacheRequirement, (org.jboss.as.clustering.controller.Capability)new UnaryRequirementCapability(clusteringCacheRequirement.getDefaultRequirement()));
        }
        ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setAllowExpression(false)).build();
        ALIAS_ADD = new SimpleOperationDefinitionBuilder("add-alias", InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{WILDCARD_PATH})).setParameters(new AttributeDefinition[]{ALIAS}).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion()).build();
        ALIAS_REMOVE = new SimpleOperationDefinitionBuilder("remove-alias", InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{WILDCARD_PATH})).setParameters(new AttributeDefinition[]{ALIAS}).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion()).build();
    }

    @Deprecated
    static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        JNDI_NAME("jndi-name", ModelType.STRING, InfinispanModel.VERSION_6_0_0),
        START("start", ModelType.STRING, InfinispanModel.VERSION_3_0_0){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode(StartMode.LAZY.name()))).setValidator((ParameterValidator)new EnumValidator(StartMode.class));
            }
        };

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, InfinispanModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply(CacheContainerResourceDefinition.createBuilder(name, type)).setDeprecated(deprecation.getVersion())).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    @Deprecated
    static enum ExecutorAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        EVICTION("eviction-executor"),
        LISTENER("listener-executor"),
        REPLICATION_QUEUE("replication-queue-executor");

        private final AttributeDefinition definition;

        private ExecutorAttribute(String name) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)CacheContainerResourceDefinition.createBuilder(name, ModelType.STRING).setAllowExpression(false)).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion())).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        ALIASES("aliases"),
        DEFAULT_CACHE("default-cache", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference(DEFAULT_CAPABILITIES.get(InfinispanCacheRequirement.CONFIGURATION), (BinaryRequirement)InfinispanCacheRequirement.CONFIGURATION, WILDCARD_PATH));
            }
        }
        ,
        MODULE("module", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode("org.jboss.as.clustering.infinispan"))).setValidator(new ModuleIdentifierValidatorBuilder().configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        }
        ,
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode(false));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply(CacheContainerResourceDefinition.createBuilder(name, type)).build();
        }

        private Attribute(String name) {
            this.definition = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    static enum Capability implements CapabilityProvider
    {
        CONTAINER((UnaryRequirement)InfinispanRequirement.CONTAINER),
        CONFIGURATION((UnaryRequirement)InfinispanRequirement.CONFIGURATION),
        KEY_AFFINITY_FACTORY((UnaryRequirement)InfinispanRequirement.KEY_AFFINITY_FACTORY);

        private final org.jboss.as.clustering.controller.Capability capability;

        private Capability(UnaryRequirement requirement) {
            this.capability = new UnaryRequirementCapability(requirement);
        }

        public org.jboss.as.clustering.controller.Capability getCapability() {
            return this.capability;
        }
    }
}

