/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.jboss.dmr.Base64;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;
import org.jboss.dmr.stream.ModelException;
import org.jboss.dmr.stream.ModelWriter;

final class BytesModelValue
extends ModelValue {
    public static final String TYPE_KEY = "BYTES_VALUE";
    private final byte[] bytes;

    BytesModelValue(byte[] bytes) {
        super(ModelType.BYTES);
        this.bytes = bytes;
    }

    BytesModelValue(DataInput in) throws IOException {
        super(ModelType.BYTES);
        byte[] b = new byte[in.readInt()];
        in.readFully(b);
        this.bytes = b;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.write(ModelType.BYTES.typeChar);
        out.writeInt(this.bytes.length);
        out.write(this.bytes);
    }

    @Override
    long asLong() {
        byte[] bytes = this.bytes;
        int length = bytes.length;
        int cnt = Math.min(8, length);
        long v = 0L;
        for (int i = 0; i < cnt; ++i) {
            v <<= 8;
            v |= (long)(bytes[length - cnt + i] & 0xFF);
        }
        return v;
    }

    @Override
    long asLong(long defVal) {
        return this.asLong();
    }

    @Override
    int asInt() {
        byte[] bytes = this.bytes;
        int length = bytes.length;
        int cnt = Math.min(4, length);
        int v = 0;
        for (int i = 0; i < cnt; ++i) {
            v <<= 8;
            v |= bytes[length - cnt + i] & 0xFF;
        }
        return v;
    }

    @Override
    int asInt(int defVal) {
        return this.asInt();
    }

    @Override
    double asDouble() {
        return Double.longBitsToDouble(this.asLong());
    }

    @Override
    double asDouble(double defVal) {
        return Double.longBitsToDouble(this.asLong());
    }

    @Override
    BigDecimal asBigDecimal() {
        return new BigDecimal(new BigInteger(this.bytes));
    }

    @Override
    BigInteger asBigInteger() {
        return new BigInteger(this.bytes);
    }

    @Override
    byte[] asBytes() {
        return (byte[])this.bytes.clone();
    }

    @Override
    String asString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter, true);
        this.format(writer, 0, false);
        return stringWriter.toString();
    }

    @Override
    void formatAsJSON(PrintWriter writer, int indent, boolean multiLine) {
        writer.append('{');
        if (multiLine) {
            BytesModelValue.indent(writer.append('\n'), indent + 1);
        } else {
            writer.append(' ');
        }
        writer.append(BytesModelValue.jsonEscape(TYPE_KEY));
        writer.append(" : ");
        writer.append(BytesModelValue.jsonEscape(Base64.encodeBytes(this.bytes)));
        if (multiLine) {
            BytesModelValue.indent(writer.append('\n'), indent);
        } else {
            writer.append(' ');
        }
        writer.append('}');
    }

    @Override
    void format(PrintWriter writer, int indent, boolean multiLine) {
        writer.append("bytes {");
        if (multiLine) {
            writer.append('\n');
            BytesModelValue.indent(writer, indent + 1);
        } else {
            writer.append(' ');
        }
        int length = this.bytes.length;
        for (int i = 0; i < length; ++i) {
            byte b = this.bytes[i];
            if (b >= 0 && b < 16) {
                writer.append("0x0").append(Integer.toHexString(b & 0xFF));
            } else {
                writer.append("0x").append(Integer.toHexString(b & 0xFF));
            }
            if (i == length - 1) continue;
            if (multiLine && (i & 7) == 7) {
                BytesModelValue.indent(writer.append(",\n"), indent + 1);
                continue;
            }
            writer.append(", ");
        }
        if (multiLine) {
            BytesModelValue.indent(writer.append('\n'), indent);
        } else {
            writer.append(' ');
        }
        writer.append('}');
    }

    void formatMultiLine(PrintWriter writer, int indent) {
        int length = this.bytes.length;
        this.format(writer, indent, length > 8);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof BytesModelValue && this.equals((BytesModelValue)other);
    }

    public boolean equals(BytesModelValue other) {
        return this == other || other != null && Arrays.equals(this.bytes, other.bytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes) + 71;
    }

    @Override
    void write(ModelWriter writer) throws IOException, ModelException {
        writer.writeBytes(this.bytes);
    }
}

