/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.bulkhead;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;

public abstract class BulkheadBase<V>
implements FaultToleranceStrategy<V> {
    private final String description;
    final FaultToleranceStrategy<V> delegate;
    final MetricsRecorder recorder;

    BulkheadBase(String description, FaultToleranceStrategy<V> delegate, MetricsRecorder recorder) {
        this.description = description;
        this.delegate = delegate;
        this.recorder = recorder == null ? MetricsRecorder.NOOP : recorder;
    }

    BulkheadException bulkheadRejected() {
        return new BulkheadException(this.description + " rejected from bulkhead");
    }

    public static interface MetricsRecorder {
        public static final MetricsRecorder NOOP = new MetricsRecorder(){

            @Override
            public void bulkheadQueueEntered() {
            }

            @Override
            public void bulkheadQueueLeft(long timeInQueue) {
            }

            @Override
            public void bulkheadEntered() {
            }

            @Override
            public void bulkheadRejected() {
            }

            @Override
            public void bulkheadLeft(long processingTime) {
            }
        };

        public void bulkheadQueueEntered();

        public void bulkheadQueueLeft(long var1);

        public void bulkheadEntered();

        public void bulkheadRejected();

        public void bulkheadLeft(long var1);
    }
}

