/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class IracCleanupKeyCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 122;
    private ByteString cacheName;
    private Object key;
    private Object lockOwner;
    private IracMetadata tombstone;

    public IracCleanupKeyCommand() {
    }

    public IracCleanupKeyCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public IracCleanupKeyCommand(ByteString cacheName, Object key, Object lockOwner, IracMetadata tombstone) {
        this.cacheName = cacheName;
        this.key = key;
        this.lockOwner = lockOwner;
        this.tombstone = tombstone;
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    public CompletableFuture<Object> invokeAsync(ComponentRegistry componentRegistry) {
        componentRegistry.getIracManager().running().cleanupKey(this.key, this.lockOwner, this.tombstone);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 122;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        boolean cId = this.lockOwner instanceof CommandInvocationId;
        output.writeBoolean(cId);
        if (cId) {
            CommandInvocationId.writeTo(output, (CommandInvocationId)this.lockOwner);
        } else {
            output.writeObject(this.lockOwner);
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        boolean cId = input.readBoolean();
        this.lockOwner = cId ? CommandInvocationId.readFrom(input) : input.readObject();
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public String toString() {
        return "IracCleanupKeyCommand{key=" + this.key + ", lockOwner=" + this.lockOwner + '}';
    }
}

