/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=4)
public class EmbeddedMetadata
implements Metadata {
    public static final EmbeddedMetadata EMPTY = new EmbeddedMetadata(null, null);
    protected final EntryVersion version;

    private EmbeddedMetadata(EntryVersion version) {
        this.version = version;
    }

    @ProtoFactory
    EmbeddedMetadata(NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
        this.version = numericVersion != null ? numericVersion : clusteredVersion;
    }

    @Override
    public long lifespan() {
        return -1L;
    }

    @Override
    public long maxIdle() {
        return -1L;
    }

    @Override
    public EntryVersion version() {
        return this.version;
    }

    @ProtoField(number=1)
    public NumericVersion getNumericVersion() {
        return this.version instanceof NumericVersion ? (NumericVersion)this.version : null;
    }

    @ProtoField(number=2)
    public SimpleClusteredVersion getClusteredVersion() {
        return this.version instanceof SimpleClusteredVersion ? (SimpleClusteredVersion)this.version : null;
    }

    @Override
    public Metadata.Builder builder() {
        return new Builder().version(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedMetadata that = (EmbeddedMetadata)o;
        return this.version != null ? this.version.equals(that.version) : that.version == null;
    }

    public int hashCode() {
        return this.version != null ? this.version.hashCode() : 0;
    }

    public String toString() {
        return "EmbeddedMetadata{version=" + this.version + '}';
    }

    private static long toMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? -1L : timeUnit.toMillis(duration);
    }

    public static class Externalizer
    extends AbstractExternalizer<EmbeddedMetadata> {
        private static final int IMMORTAL = 0;
        private static final int EXPIRABLE = 1;
        private static final int LIFESPAN_EXPIRABLE = 2;
        private static final int MAXIDLE_EXPIRABLE = 3;
        private final Map<Class<?>, Integer> numbers = new HashMap(2);

        public Externalizer() {
            this.numbers.put(EmbeddedMetadata.class, 0);
            this.numbers.put(EmbeddedExpirableMetadata.class, 1);
            this.numbers.put(EmbeddedLifespanExpirableMetadata.class, 2);
            this.numbers.put(EmbeddedMaxIdleExpirableMetadata.class, 3);
        }

        public Set<Class<? extends EmbeddedMetadata>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{EmbeddedMetadata.class, EmbeddedExpirableMetadata.class, EmbeddedLifespanExpirableMetadata.class, EmbeddedMaxIdleExpirableMetadata.class});
        }

        public Integer getId() {
            return 57;
        }

        public void writeObject(ObjectOutput output, EmbeddedMetadata object) throws IOException {
            int number = this.numbers.getOrDefault(object.getClass(), -1);
            output.write(number);
            switch (number) {
                case 1: {
                    output.writeLong(object.lifespan());
                    output.writeLong(object.maxIdle());
                    break;
                }
                case 2: {
                    output.writeLong(object.lifespan());
                    break;
                }
                case 3: {
                    output.writeLong(object.maxIdle());
                }
            }
            output.writeObject(object.version());
        }

        public EmbeddedMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte number = input.readByte();
            switch (number) {
                case 0: {
                    return new EmbeddedMetadata((EntryVersion)input.readObject());
                }
                case 1: {
                    long lifespan = EmbeddedMetadata.toMillis(input.readLong(), TimeUnit.MILLISECONDS);
                    long maxIdle = EmbeddedMetadata.toMillis(input.readLong(), TimeUnit.MILLISECONDS);
                    return new EmbeddedExpirableMetadata(lifespan, maxIdle, (EntryVersion)input.readObject());
                }
                case 2: {
                    long lifespan = EmbeddedMetadata.toMillis(input.readLong(), TimeUnit.MILLISECONDS);
                    return new EmbeddedLifespanExpirableMetadata(lifespan, (EntryVersion)input.readObject());
                }
                case 3: {
                    long maxIdle = EmbeddedMetadata.toMillis(input.readLong(), TimeUnit.MILLISECONDS);
                    return new EmbeddedMaxIdleExpirableMetadata(maxIdle, (EntryVersion)input.readObject());
                }
            }
            throw new IllegalStateException("Unknown metadata type " + number);
        }
    }

    @ProtoTypeId(value=7)
    public static class EmbeddedMaxIdleExpirableMetadata
    extends EmbeddedMetadata {
        private final long maxIdle;

        @ProtoFactory
        EmbeddedMaxIdleExpirableMetadata(long maxIdle, NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
            this(maxIdle, numericVersion != null ? numericVersion : clusteredVersion);
        }

        private EmbeddedMaxIdleExpirableMetadata(long maxIdle, EntryVersion entryVersion) {
            super(entryVersion);
            this.maxIdle = maxIdle;
        }

        @Override
        @ProtoField(number=3, defaultValue="-1")
        public long maxIdle() {
            return this.maxIdle;
        }

        @Override
        public Metadata.Builder builder() {
            return super.builder().maxIdle(this.maxIdle);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmbeddedMaxIdleExpirableMetadata that = (EmbeddedMaxIdleExpirableMetadata)o;
            return this.maxIdle == that.maxIdle;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.maxIdle);
        }

        @Override
        public String toString() {
            return "EmbeddedMaxIdleExpirableMetadata{version=" + this.version + ", maxIdle=" + this.maxIdle + '}';
        }
    }

    @ProtoTypeId(value=6)
    public static class EmbeddedLifespanExpirableMetadata
    extends EmbeddedMetadata {
        private final long lifespan;

        protected EmbeddedLifespanExpirableMetadata(long lifespan, EntryVersion version) {
            super(version);
            this.lifespan = lifespan;
        }

        @ProtoFactory
        protected EmbeddedLifespanExpirableMetadata(long lifespan, NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
            this(lifespan, numericVersion != null ? numericVersion : clusteredVersion);
        }

        @Override
        @ProtoField(number=3, defaultValue="-1")
        public long lifespan() {
            return this.lifespan;
        }

        @Override
        public Metadata.Builder builder() {
            return super.builder().lifespan(this.lifespan);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmbeddedLifespanExpirableMetadata that = (EmbeddedLifespanExpirableMetadata)o;
            return this.lifespan == that.lifespan;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.lifespan);
        }

        @Override
        public String toString() {
            return "EmbeddedLifespanExpirableMetadata{lifespan=" + this.lifespan + ", version=" + this.version + '}';
        }
    }

    @ProtoTypeId(value=5)
    public static class EmbeddedExpirableMetadata
    extends EmbeddedMetadata {
        private final long lifespan;
        private final long maxIdle;

        @ProtoFactory
        EmbeddedExpirableMetadata(long lifespan, long maxIdle, NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion) {
            this(lifespan, maxIdle, numericVersion != null ? numericVersion : clusteredVersion);
        }

        private EmbeddedExpirableMetadata(long lifespan, long maxIdle, EntryVersion version) {
            super(version);
            this.lifespan = lifespan;
            this.maxIdle = maxIdle;
        }

        @Override
        @ProtoField(number=3, defaultValue="-1")
        public long lifespan() {
            return this.lifespan;
        }

        @Override
        @ProtoField(number=4, defaultValue="-1")
        public long maxIdle() {
            return this.maxIdle;
        }

        @Override
        public Metadata.Builder builder() {
            return super.builder().lifespan(this.lifespan).maxIdle(this.maxIdle);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmbeddedExpirableMetadata that = (EmbeddedExpirableMetadata)o;
            return this.lifespan == that.lifespan && this.maxIdle == that.maxIdle;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.lifespan, this.maxIdle);
        }

        @Override
        public String toString() {
            return "EmbeddedExpirableMetadata{version=" + this.version + ", lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + '}';
        }
    }

    public static class Builder
    implements Metadata.Builder {
        protected Long lifespan = null;
        protected TimeUnit lifespanUnit = TimeUnit.MILLISECONDS;
        protected Long maxIdle = null;
        protected TimeUnit maxIdleUnit = TimeUnit.MILLISECONDS;
        protected EntryVersion version;

        @Override
        public Metadata.Builder lifespan(long time, TimeUnit unit) {
            this.lifespan = time;
            this.lifespanUnit = unit;
            return this;
        }

        @Override
        public Metadata.Builder lifespan(long time) {
            return this.lifespan(time, TimeUnit.MILLISECONDS);
        }

        @Override
        public Metadata.Builder maxIdle(long time, TimeUnit unit) {
            this.maxIdle = time;
            this.maxIdleUnit = unit;
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time) {
            return this.maxIdle(time, TimeUnit.MILLISECONDS);
        }

        @Override
        public Metadata.Builder version(EntryVersion version) {
            this.version = version;
            return this;
        }

        @Override
        public Metadata build() {
            boolean hasLifespan = this.hasLifespan();
            boolean hasMaxIdle = this.hasMaxIdle();
            if (hasLifespan && hasMaxIdle) {
                return new EmbeddedExpirableMetadata(EmbeddedMetadata.toMillis(this.lifespan, this.lifespanUnit), EmbeddedMetadata.toMillis(this.maxIdle, this.maxIdleUnit), this.version);
            }
            if (hasLifespan) {
                return new EmbeddedLifespanExpirableMetadata(EmbeddedMetadata.toMillis(this.lifespan, this.lifespanUnit), this.version);
            }
            if (hasMaxIdle) {
                return new EmbeddedMaxIdleExpirableMetadata(EmbeddedMetadata.toMillis(this.maxIdle, this.lifespanUnit), this.version);
            }
            return new EmbeddedMetadata(this.version);
        }

        protected boolean hasLifespan() {
            return this.lifespan != null;
        }

        protected boolean hasMaxIdle() {
            return this.maxIdle != null;
        }

        @Override
        public Metadata.Builder merge(Metadata metadata) {
            if (this.lifespan == null) {
                this.lifespan = metadata.lifespan();
                this.lifespanUnit = TimeUnit.MILLISECONDS;
            }
            if (this.maxIdle == null) {
                this.maxIdle = metadata.maxIdle();
                this.maxIdleUnit = TimeUnit.MILLISECONDS;
            }
            if (this.version == null) {
                this.version = metadata.version();
            }
            return this;
        }
    }
}

