/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tools.migrate.config;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.activemq.artemis.tools.migrate.config.addressing.Address;
import org.apache.activemq.artemis.tools.migrate.config.addressing.Queue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigurationMigration {
    private static final String xPathAttrName = "@name";
    private static final String xPathJMS = "/configuration/jms";
    private static final String xPathJMSQueues = "/configuration/jms/queue";
    private static final String xPathJMSTopics = "/configuration/jms/topic";
    private static final String xPathQueues = "/configuration/core/queues";
    private static final String xPathQueue = "/configuration/core/queues/queue";
    private static final String xPathAddress = "address";
    private static final String xPathFilter = "filter/@string";
    private static final String xPathSelector = "selector/@string";
    private static final String xPathDurable = "durable";
    private final Map<String, Address> coreAddresses = new HashMap<String, Address>();
    private final Document document;
    private final File input;
    private final File output;
    private final Node coreElement;
    private final XPath xPath;

    public XMLConfigurationMigration(File input, File output) throws Exception {
        this.input = input;
        this.output = output;
        try {
            if (!input.exists()) {
                throw new Exception("Input file not found: " + input);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            this.document = db.parse(this.input);
            this.xPath = XPathFactory.newInstance().newXPath();
            this.coreElement = (Node)this.xPath.evaluate("/configuration/core", this.document, XPathConstants.NODE);
            if (this.coreElement == null) {
                throw new Exception("Not a artemis config");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public boolean transform() throws Exception {
        try {
            boolean queuesChanged = this.convertQueuesToAddresses();
            boolean jmsChanged = this.convertJMSToAddresses();
            this.writeAddressesToDocument();
            this.document.normalize();
            if (queuesChanged || jmsChanged) {
                Properties properties = new Properties();
                properties.put("indent", "yes");
                properties.put("{http://xml.apache.org/xslt}indent-amount", "3");
                properties.put("encoding", "UTF-8");
                this.write(this.output, properties);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Error tranforming document");
            e.printStackTrace();
        }
        return false;
    }

    public boolean convertQueuesToAddresses() throws Exception {
        Node coreQueuesElement = this.getNode(xPathQueues);
        if (coreQueuesElement == null) {
            return false;
        }
        NodeList coreQueueElements = this.getNodeList(xPathQueue);
        for (int i = 0; i < coreQueueElements.getLength(); ++i) {
            Address address;
            Node queueNode = coreQueueElements.item(i);
            Queue queue = new Queue();
            queue.setName(this.getString(queueNode, xPathAttrName));
            queue.setDurable(this.getString(queueNode, xPathDurable));
            queue.setFilter(this.getString(queueNode, xPathFilter));
            queue.setRoutingType("multicast");
            String addressName = this.getString(queueNode, xPathAddress);
            if (this.coreAddresses.containsKey(addressName)) {
                address = this.coreAddresses.get(addressName);
            } else {
                address = new Address();
                address.setName(addressName);
                this.coreAddresses.put(addressName, address);
            }
            address.getQueues().add(queue);
            address.getRoutingTypes().add("multicast");
        }
        Node queues = this.getNode(xPathQueues);
        if (queues != null) {
            this.coreElement.removeChild(queues);
        }
        return true;
    }

    public boolean convertJMSToAddresses() throws Exception {
        Node jmsElement = this.getNode(xPathJMS);
        if (jmsElement == null) {
            return false;
        }
        NodeList jmsQueueElements = this.getNodeList(xPathJMSQueues);
        for (int i = 0; i < jmsQueueElements.getLength(); ++i) {
            Address address;
            Node jmsQueueElement = jmsQueueElements.item(i);
            String name = this.getString(jmsQueueElement, xPathAttrName);
            if (this.coreAddresses.containsKey(name)) {
                address = this.coreAddresses.get(name);
            } else {
                address = new Address();
                address.setName(name);
                address.getRoutingTypes().add("anycast");
                this.coreAddresses.put(name, address);
            }
            Queue queue = new Queue();
            queue.setName(name);
            queue.setDurable(this.getString(jmsQueueElement, xPathDurable));
            queue.setFilter(this.getString(jmsQueueElement, xPathSelector));
            queue.setRoutingType("anycast");
            address.getQueues().add(queue);
            address.getRoutingTypes().add("anycast");
        }
        NodeList jmsTopicElements = this.getNodeList(xPathJMSTopics);
        for (int i = 0; i < jmsTopicElements.getLength(); ++i) {
            Address address;
            Node jmsTopicElement = jmsTopicElements.item(i);
            String name = this.getString(jmsTopicElement, xPathAttrName);
            if (this.coreAddresses.containsKey(name)) {
                address = this.coreAddresses.get(name);
            } else {
                address = new Address();
                address.setName(name);
                address.getRoutingTypes().add("multicast");
                this.coreAddresses.put(name, address);
            }
            address.getRoutingTypes().add("multicast");
        }
        jmsElement.getParentNode().removeChild(jmsElement);
        return true;
    }

    public void writeAddressesToDocument() throws XPathExpressionException {
        Element addressElement = this.document.createElement("addresses");
        this.writeAddressListToDoc(this.coreAddresses.values(), addressElement);
        this.coreElement.appendChild(addressElement);
    }

    private void writeAddressListToDoc(Collection<Address> addresses, Node addressElement) throws XPathExpressionException {
        if (addresses.isEmpty()) {
            return;
        }
        for (Address addr : addresses) {
            Element eAddr = this.document.createElement(xPathAddress);
            eAddr.setAttribute("name", addr.getName());
            Element eMulticast = null;
            if (addr.getRoutingTypes().contains("multicast") && (eMulticast = (Element)eAddr.getElementsByTagName("multicast").item(0)) == null) {
                eMulticast = this.document.createElement("multicast");
                eAddr.appendChild(eMulticast);
            }
            Element eAnycast = null;
            if (addr.getRoutingTypes().contains("anycast") && (eAnycast = (Element)eAddr.getElementsByTagName("anycast").item(0)) == null) {
                eAnycast = this.document.createElement("anycast");
                eAddr.appendChild(eAnycast);
            }
            if (addr.getQueues().size() > 0) {
                for (Queue queue : addr.getQueues()) {
                    Element eQueue = this.document.createElement("queue");
                    eQueue.setAttribute("name", queue.getName());
                    if (queue.getDurable() != null && !queue.getDurable().isEmpty()) {
                        Element eDurable = this.document.createElement(xPathDurable);
                        eDurable.setTextContent(queue.getDurable());
                        eQueue.appendChild(eDurable);
                    }
                    if (queue.getFilter() != null && !queue.getFilter().isEmpty()) {
                        Element eFilter = this.document.createElement("filter");
                        eFilter.setAttribute("string", queue.getFilter());
                        eQueue.appendChild(eFilter);
                    }
                    if (queue.getRoutingType().equals("anycast")) {
                        eAnycast.appendChild(eQueue);
                        continue;
                    }
                    if (queue.getRoutingType().equals("multicast")) {
                        eMulticast.appendChild(eQueue);
                        continue;
                    }
                    System.err.print("Unknown Routing Type Found for Queue: " + queue.getName());
                }
            }
            addressElement.appendChild(eAddr);
        }
    }

    public void write(File output, Properties outputProperties) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperties(outputProperties);
        StreamResult streamResult = new StreamResult(output);
        transformer.transform(new DOMSource(this.document), streamResult);
    }

    private String getString(Node node, String xPathQuery) throws XPathExpressionException {
        return this.xPath.evaluate(xPathQuery, node, XPathConstants.STRING).toString();
    }

    private NodeList getNodeList(String xPathQuery) throws XPathExpressionException {
        return (NodeList)this.xPath.evaluate(xPathQuery, this.document, XPathConstants.NODESET);
    }

    private Node getNode(String xPathQuery) throws XPathExpressionException {
        return (Node)this.xPath.evaluate(xPathQuery, this.document, XPathConstants.NODE);
    }
}

