/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;

public class DomainManagedServerCallbackHandler
implements Service,
CallbackHandlerService,
CallbackHandler {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"domain", "management", "security", "server-auth"});
    public static final String DOMAIN_SERVER_AUTH_REALM = System.getProperty("org.jboss.as.domain.management.security.domain-auth-realm-name", "internal-domain-server-auth-realm");
    public static final String DOMAIN_SERVER_AUTH_PREFIX = System.getProperty("org.jboss.as.domain.management.security.domain-auth-server-prefix", "=");
    private static final String SERVICE_SUFFIX = "internal-domain-server-authentication";
    private final Consumer<CallbackHandlerService> callbackHandlerServiceConsumer;
    private volatile CallbackHandler serverCallbackHandler;

    DomainManagedServerCallbackHandler(Consumer<CallbackHandlerService> callbackHandlerServiceConsumer) {
        this.callbackHandlerServiceConsumer = callbackHandlerServiceConsumer;
    }

    public static void install(ServiceTarget serviceTarget) {
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME);
        Consumer chsConsumer = builder.provides(new ServiceName[]{SERVICE_NAME});
        builder.setInstance((Service)new DomainManagedServerCallbackHandler(chsConsumer));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    public void setServerCallbackHandler(CallbackHandler serverCallbackHandler) {
        if (this.serverCallbackHandler != null) {
            throw new UnsupportedOperationException();
        }
        this.serverCallbackHandler = serverCallbackHandler;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.PLAIN;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.singletonMap("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new SecurityRealmImpl();
    }

    public void start(StartContext context) throws StartException {
        this.callbackHandlerServiceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.callbackHandlerServiceConsumer.accept(null);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        CallbackHandler serverCallbackHandler = this.serverCallbackHandler;
        if (serverCallbackHandler != null) {
            serverCallbackHandler.handle(callbacks);
        }
    }

    @Override
    public Function<Principal, Principal> getPrincipalMapper() {
        return p -> p instanceof RealmUser ? new RealmUser(DOMAIN_SERVER_AUTH_REALM, p.getName()) : p;
    }

    private char[] fetchCredential(String serverName) throws UnsupportedCallbackException, IOException {
        CallbackHandler serverCallbackHandler = this.serverCallbackHandler;
        if (serverCallbackHandler == null) {
            throw DomainManagementLogger.ROOT_LOGGER.callbackHandlerNotInitialized(serverName);
        }
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        NameCallback nc = new NameCallback("None", serverName);
        callbacks.add(nc);
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        callbacks.add(pc);
        serverCallbackHandler.handle(callbacks.toArray(new Callback[callbacks.size()]));
        return pc.getPassword();
    }

    private static PasswordFactory getPasswordFactory(String algorithm) {
        try {
            return PasswordFactory.getInstance((String)algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{DomainManagedServerCallbackHandler.SERVICE_SUFFIX});
        }
    }

    private class SecurityRealmImpl
    implements SecurityRealm {
        private SecurityRealmImpl() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            String name = principal.getName();
            return new RealmIdentityImpl(principal, name);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return PasswordCredential.class.isAssignableFrom(credentialType) && (algorithmName == null || algorithmName.equals("clear") || algorithmName.equals("digest-md5")) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.SUPPORTED;
        }

        private class RealmIdentityImpl
        implements RealmIdentity {
            private final Principal principal;
            private final String serverName;

            private RealmIdentityImpl(Principal principal, String serverName) {
                this.principal = principal;
                this.serverName = serverName;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return this.getCredential(credentialType, null);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
                return this.getCredential(credentialType, algorithmName, null);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                char[] password;
                if (this.serverName == null || !PasswordCredential.class.isAssignableFrom(credentialType)) {
                    return null;
                }
                try {
                    password = DomainManagedServerCallbackHandler.this.fetchCredential(this.serverName);
                    if (password == null) {
                        return null;
                    }
                }
                catch (Exception e) {
                    throw new RealmUnavailableException((Throwable)e);
                }
                if (algorithmName == null || "clear".equals(algorithmName)) {
                    PasswordFactory passwordFactory = DomainManagedServerCallbackHandler.getPasswordFactory("clear");
                    ClearPasswordSpec passwordSpec = new ClearPasswordSpec(password);
                    try {
                        return (C)((Credential)credentialType.cast(new PasswordCredential(passwordFactory.generatePassword((KeySpec)passwordSpec))));
                    }
                    catch (InvalidKeySpecException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if ("digest-md5".equals(algorithmName)) {
                    try {
                        PasswordFactory instance = PasswordFactory.getInstance((String)"digest-md5");
                        Password pwd = instance.generatePassword((KeySpec)new EncryptablePasswordSpec(password, (AlgorithmParameterSpec)new DigestPasswordAlgorithmSpec(this.serverName, DOMAIN_SERVER_AUTH_REALM)));
                        return (C)((Credential)credentialType.cast(new PasswordCredential(pwd)));
                    }
                    catch (Exception e) {
                        throw new RealmUnavailableException((Throwable)e);
                    }
                }
                throw DomainManagementLogger.ROOT_LOGGER.unableToObtainCredential(this.serverName);
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                char[] password;
                if (this.serverName == null || !(evidence instanceof PasswordGuessEvidence)) {
                    return false;
                }
                char[] guess = ((PasswordGuessEvidence)evidence).getGuess();
                try {
                    password = DomainManagedServerCallbackHandler.this.fetchCredential(this.serverName);
                    if (password == null) {
                        return false;
                    }
                }
                catch (Exception e) {
                    throw new RealmUnavailableException((Throwable)e);
                }
                PasswordFactory passwordFactory = DomainManagedServerCallbackHandler.getPasswordFactory("clear");
                ClearPasswordSpec passwordSpec = new ClearPasswordSpec(password);
                try {
                    Password actualPassword = passwordFactory.generatePassword((KeySpec)passwordSpec);
                    return passwordFactory.verify(actualPassword, guess);
                }
                catch (IllegalStateException | InvalidKeyException | InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
            }

            public boolean exists() throws RealmUnavailableException {
                return this.serverName != null;
            }
        }
    }
}

