/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.trace.BigendianEncoding;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SpanId {
    private static final ThreadLocal<char[]> charBuffer = new ThreadLocal();
    private static final int HEX_LENGTH = 16;
    private static final String INVALID = "0000000000000000";

    private SpanId() {
    }

    public static int getLength() {
        return 16;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence spanId) {
        return spanId != null && spanId.length() == 16 && !INVALID.contentEquals(spanId) && BigendianEncoding.isValidBase16String(spanId);
    }

    public static String fromBytes(byte[] spanIdBytes) {
        if (spanIdBytes == null) {
            return INVALID;
        }
        char[] result = SpanId.getTemporaryBuffer();
        BigendianEncoding.bytesToBase16(spanIdBytes, result);
        return new String(result);
    }

    public static String fromLong(long id) {
        if (id == 0L) {
            return SpanId.getInvalid();
        }
        char[] result = SpanId.getTemporaryBuffer();
        BigendianEncoding.longToBase16String(id, result, 0);
        return new String(result);
    }

    private static char[] getTemporaryBuffer() {
        char[] chars = charBuffer.get();
        if (chars == null) {
            chars = new char[16];
            charBuffer.set(chars);
        }
        return chars;
    }
}

