/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.extension.AbstractEmitter;
import io.smallrye.reactive.messaging.extension.EmitterConfiguration;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class MutinyEmitterImpl<T>
extends AbstractEmitter<T>
implements MutinyEmitter<T> {
    public MutinyEmitterImpl(EmitterConfiguration config, long defaultBufferSize) {
        super(config, defaultBufferSize);
    }

    public Uni<Void> send(T payload) {
        if (payload == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        return Uni.createFrom().emitter(e -> this.emit(Message.of((Object)payload, (Metadata)Metadata.empty(), () -> {
            e.complete(null);
            return CompletableFuture.completedFuture(null);
        }, reason -> {
            e.fail(reason);
            return CompletableFuture.completedFuture(null);
        })));
    }

    public void sendAndAwait(T payload) {
        this.send(payload).await().indefinitely();
    }

    public Cancellable sendAndForget(T payload) {
        return this.send(payload).subscribe().with(x -> {}, ProviderLogging.log::failureEmittingMessage);
    }

    public <M extends Message<? extends T>> void send(M msg) {
        if (msg == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        Uni.createFrom().emitter(e -> this.emit(msg)).subscribe().with(x -> {}, ProviderLogging.log::failureEmittingMessage);
    }
}

