/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.hostbased;

import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthHostBased
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "hostbased";
    private List<NamedFactory<Signature>> factories;

    public UserAuthHostBased() {
        this((List<NamedFactory<Signature>>)null);
    }

    public UserAuthHostBased(List<NamedFactory<Signature>> factories) {
        super(NAME);
        this.factories = factories;
    }

    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        boolean authed;
        HostBasedAuthenticator authenticator;
        ValidateUtils.checkTrue((boolean)init, (String)"Instance not initialized");
        int dataLen = buffer.available();
        String username = this.getUsername();
        ServerSession session = this.getSession();
        String keyType = buffer.getString();
        int keyLen = buffer.getInt();
        int keyOffset = buffer.rpos();
        int remaining = buffer.available();
        if (keyLen < 0 || keyLen > remaining) {
            this.log.error("doAuth({}@{}) Illogical {} key length={} (max. available={})", new Object[]{username, session, keyType, keyLen, remaining});
            throw new IndexOutOfBoundsException("Illogical " + keyType + " key length: " + keyLen);
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(buffer.array(), keyOffset, keyLen, true);
        PublicKey clientKey = buf.getRawPublicKey();
        List<X509Certificate> certs = Collections.emptyList();
        remaining = buf.available();
        if (remaining > 0) {
            CertificateFactory cf = SecurityUtils.getCertificateFactory((String)"X.509");
            certs = new ArrayList();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(buf.array(), buf.rpos(), remaining);){
                X509Certificate c = (X509Certificate)cf.generateCertificate(bais);
                certs.add(c);
            }
        }
        buffer.rpos(keyOffset + keyLen);
        String clientHostName = buffer.getString();
        String clientUsername = buffer.getString();
        byte[] signature = buffer.getBytes();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) authenticate key type={}, fingerprint={}, client={}@{}, num-certs={}", new Object[]{username, session, keyType, KeyUtils.getFingerPrint((PublicKey)clientKey), clientUsername, clientHostName, GenericUtils.size(certs)});
        }
        if ((authenticator = session.getHostBasedAuthenticator()) == null) {
            if (debugEnabled) {
                this.log.debug("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - no authenticator", new Object[]{username, session, keyType, KeyUtils.getFingerPrint((PublicKey)clientKey), clientUsername, clientHostName, GenericUtils.size(certs)});
            }
            return Boolean.FALSE;
        }
        try {
            authed = authenticator.authenticate(session, username, clientKey, clientHostName, clientUsername, certs);
        }
        catch (Error e) {
            this.log.warn("doAuth({}@{}) failed ({}) to consult authenticator for {} key={}: {}", new Object[]{username, session, e.getClass().getSimpleName(), keyType, KeyUtils.getFingerPrint((PublicKey)clientKey), e.getMessage()});
            if (debugEnabled) {
                this.log.debug("doAuth(" + username + "@" + session + ") delegate consultation failure details", (Throwable)e);
            }
            throw new RuntimeSshException((Throwable)e);
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - authentication result: {}", new Object[]{username, session, keyType, KeyUtils.getFingerPrint((PublicKey)clientKey), clientUsername, clientHostName, GenericUtils.size(certs), authed});
        }
        if (!authed) {
            return Boolean.FALSE;
        }
        Collection factories = ValidateUtils.checkNotNullAndNotEmpty((Collection)SignatureFactoriesManager.resolveSignatureFactories((SignatureFactoriesManager)this, (SignatureFactoriesManager)session), (String)"No signature factories for session=%s", (Object[])new Object[]{session});
        Signature verifier = (Signature)ValidateUtils.checkNotNull((Object)NamedFactory.create((Collection)factories, (String)keyType), (String)"No verifier located for algorithm=%s", (Object)keyType);
        verifier.initVerifier((SessionContext)session, clientKey);
        byte[] id = session.getSessionId();
        buf = new ByteArrayBuffer(dataLen + id.length + 64, false);
        buf.putBytes(id);
        buf.putByte((byte)50);
        buf.putString(username);
        buf.putString(this.getService());
        buf.putString(this.getName());
        buf.putString(keyType);
        buf.putInt((long)keyLen);
        buf.putRawBytes(buffer.array(), keyOffset, keyLen);
        buf.putString(clientHostName);
        buf.putString(clientUsername);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - verification data: {}", new Object[]{username, session, keyType, KeyUtils.getFingerPrint((PublicKey)clientKey), clientUsername, clientHostName, GenericUtils.size(certs), buf.toHex()});
            this.log.trace("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - expected signature: {}", new Object[]{username, session, keyType, KeyUtils.getFingerPrint((PublicKey)clientKey), clientUsername, clientHostName, GenericUtils.size(certs), BufferUtils.toHex((byte[])signature)});
        }
        verifier.update((SessionContext)session, buf.array(), buf.rpos(), buf.available());
        if (!verifier.verify((SessionContext)session, signature)) {
            throw new SignatureException("Key verification failed");
        }
        if (debugEnabled) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - verified signature", new Object[]{username, session, keyType, KeyUtils.getFingerPrint((PublicKey)clientKey), clientUsername, clientHostName, GenericUtils.size(certs)});
        }
        return Boolean.TRUE;
    }
}

