/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.spi.ByteBufferInputStream;
import protostream.com.google.protobuf.CodedInputStream;

public class DefaultProtoStreamReader
implements ProtoStreamReader {
    private final ImmutableSerializationContext context;
    private final CodedInputStream input;

    public DefaultProtoStreamReader(ImmutableSerializationContext context, RawProtoStreamReader reader) {
        this(context, ((RawProtoStreamReaderImpl)reader).getDelegate());
    }

    public DefaultProtoStreamReader(ImmutableSerializationContext context, CodedInputStream input) {
        this.context = context;
        this.input = input;
    }

    @Override
    public ImmutableSerializationContext getSerializationContext() {
        return this.context;
    }

    @Override
    public <T> T readObject(Class<T> targetClass) throws IOException {
        try (ByteBufferInputStream input = new ByteBufferInputStream(this.input.readByteBuffer());){
            Object object = ProtobufUtil.readFrom((ImmutableSerializationContext)this.context, (InputStream)input, targetClass);
            return (T)object;
        }
    }

    @Override
    public <E extends Enum<E>> E readEnum(Class<E> enumClass) throws IOException {
        EnumMarshaller marshaller = (EnumMarshaller)this.context.getMarshaller(enumClass);
        int code = this.input.readEnum();
        return (E)marshaller.decode(code);
    }

    public int readTag() throws IOException {
        return this.input.readTag();
    }

    public void checkLastTagWas(int tag) throws IOException {
        this.input.checkLastTagWas(tag);
    }

    public boolean skipField(int tag) throws IOException {
        return this.input.skipField(tag);
    }

    public boolean readBool() throws IOException {
        return this.input.readBool();
    }

    public int readEnum() throws IOException {
        return this.input.readEnum();
    }

    @Override
    public byte readRawByte() throws IOException {
        return this.input.readRawByte();
    }

    public String readString() throws IOException {
        return this.input.readString();
    }

    public byte[] readByteArray() throws IOException {
        return this.input.readByteArray();
    }

    public ByteBuffer readByteBuffer() throws IOException {
        return this.input.readByteBuffer();
    }

    public double readDouble() throws IOException {
        return this.input.readDouble();
    }

    public float readFloat() throws IOException {
        return this.input.readFloat();
    }

    public long readInt64() throws IOException {
        return this.input.readInt64();
    }

    public long readUInt64() throws IOException {
        return this.input.readUInt64();
    }

    public long readSInt64() throws IOException {
        return this.input.readSInt64();
    }

    public long readFixed64() throws IOException {
        return this.input.readFixed64();
    }

    public long readSFixed64() throws IOException {
        return this.input.readSFixed64();
    }

    public long readRawVarint64() throws IOException {
        return this.input.readRawVarint64();
    }

    public int readInt32() throws IOException {
        return this.input.readInt32();
    }

    public int readUInt32() throws IOException {
        return this.input.readUInt32();
    }

    public int readSInt32() throws IOException {
        return this.input.readSInt32();
    }

    public int readFixed32() throws IOException {
        return this.input.readFixed32();
    }

    public int readSFixed32() throws IOException {
        return this.input.readSFixed32();
    }

    public int readRawVarint32() throws IOException {
        return this.input.readRawVarint32();
    }

    public int pushLimit(int limit) throws IOException {
        return this.input.pushLimit(limit);
    }

    public void popLimit(int oldLimit) {
        this.input.popLimit(oldLimit);
    }
}

