/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.cluster.impl;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.impl.Arguments;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import io.vertx.core.spi.cluster.impl.selector.Selectors;

public class DefaultNodeSelector
implements NodeSelector {
    private Selectors selectors;

    @Override
    public void init(Vertx vertx, ClusterManager clusterManager) {
        this.selectors = new Selectors(clusterManager);
    }

    @Override
    public void eventBusStarted() {
    }

    @Override
    public void selectForSend(Message<?> message, Promise<String> promise) {
        Arguments.require(message.isSend(), "selectForSend used for publishing");
        this.selectors.withSelector(message, promise, (prom, selector) -> prom.tryComplete(selector.selectForSend()));
    }

    @Override
    public void selectForPublish(Message<?> message, Promise<Iterable<String>> promise) {
        Arguments.require(!message.isSend(), "selectForPublish used for sending");
        this.selectors.withSelector(message, promise, (prom, selector) -> prom.tryComplete(selector.selectForPublish()));
    }

    @Override
    public void registrationsUpdated(RegistrationUpdateEvent event) {
        this.selectors.dataReceived(event.address(), event.registrations());
    }

    @Override
    public void registrationsLost() {
        this.selectors.dataLost();
    }
}

