/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.PlatformMBeanServerLookup;
import org.infinispan.commons.util.Util;

public class StatisticsConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> JMX_ENABLED = AttributeDefinition.builder((String)"jmx_enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<String> JMX_DOMAIN = AttributeDefinition.builder((String)"jmx_domain", (Object)"org.infinispan").immutable().build();
    public static final AttributeDefinition<MBeanServerLookup> MBEAN_SERVER_LOOKUP = AttributeDefinition.builder((String)"mbeanserverlookup", (Object)((MBeanServerLookup)Util.getInstance(PlatformMBeanServerLookup.class))).copier(IdentityAttributeCopier.INSTANCE).immutable().build();
    public static final AttributeDefinition<String> JMX_NAME = AttributeDefinition.builder((String)"jmx_name", (Object)"Default").immutable().build();
    private final Attribute<Boolean> enabled;
    private final Attribute<Boolean> jmxEnabled;
    private final Attribute<String> jmxDomain;
    private final Attribute<String> jmxName;
    private final Attribute<MBeanServerLookup> mBeanServerLookup;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(StatisticsConfiguration.class, new AttributeDefinition[]{ENABLED, JMX_ENABLED, JMX_DOMAIN, MBEAN_SERVER_LOOKUP, JMX_NAME});
    }

    StatisticsConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.jmxEnabled = attributes.attribute(JMX_ENABLED);
        this.jmxDomain = attributes.attribute(JMX_DOMAIN);
        this.jmxName = attributes.attribute(JMX_NAME);
        this.mBeanServerLookup = attributes.attribute(MBEAN_SERVER_LOOKUP);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public boolean jmxEnabled() {
        return (Boolean)this.jmxEnabled.get();
    }

    public String jmxDomain() {
        return (String)this.jmxDomain.get();
    }

    public MBeanServerLookup mbeanServerLookup() {
        return (MBeanServerLookup)this.mBeanServerLookup.get();
    }

    public String jmxName() {
        return (String)this.jmxName.get();
    }

    public String toString() {
        return this.attributes.toString(StatisticsConfiguration.class.getSimpleName());
    }
}

