/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.bindings.tomcat.SubjectSecurityInteraction;

public class PicketLinkAuthenticator
implements AuthenticationMechanism {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    static final String AUTH_METHOD_NAME = "SECURITY_DOMAIN";
    private final boolean needSubjectPrincipalSubstitution;
    private final String subjectInteractionClassName;
    private final IdentityManager identityManager;
    private final String securityDomain;
    private SubjectSecurityInteraction subjectInteraction = null;

    public PicketLinkAuthenticator(IdentityManager identityManager, Boolean needSubjectPrincipalSubstitution, String subjectInteractionClassName, String securityDomain) {
        this.identityManager = identityManager;
        this.needSubjectPrincipalSubstitution = needSubjectPrincipalSubstitution;
        this.subjectInteractionClassName = subjectInteractionClassName;
        this.securityDomain = securityDomain;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        if (this.performAuthentication(securityContext)) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }

    protected boolean performAuthentication(SecurityContext securityContext) {
        String userName;
        logger.trace("Authenticating user");
        Account account = securityContext.getAuthenticatedAccount();
        if (account != null) {
            logger.trace("Already authenticated '" + account.getPrincipal().getName() + "'");
            return true;
        }
        String password = userName = UUID.randomUUID().toString();
        Account originalPrincipal = account = this.identityManager.verify(userName, (Credential)new PasswordCredential(password.toCharArray()));
        if (account != null) {
            if (this.needSubjectPrincipalSubstitution) {
                Principal principal = this.getSubjectPrincipal();
                if (principal == null) {
                    throw new RuntimeException("Principal from subject is null");
                }
                account = this.identityManager.verify(principal.getName(), (Credential)new PasswordCredential(password.toCharArray()));
            }
            securityContext.authenticationComplete(account, AUTH_METHOD_NAME, false);
            if (originalPrincipal != null && this.needSubjectPrincipalSubstitution) {
                this.subjectInteraction.cleanup(originalPrincipal.getPrincipal());
            }
            return true;
        }
        return false;
    }

    protected Principal getSubjectPrincipal() {
        Set<Principal> principals;
        Subject subject;
        if (this.subjectInteraction == null) {
            Class<?> clazz = this.loadClass(this.getClass(), this.subjectInteractionClassName);
            try {
                this.subjectInteraction = (SubjectSecurityInteraction)clazz.newInstance();
                this.subjectInteraction.setSecurityDomain(this.securityDomain);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((subject = this.subjectInteraction.get()) != null && !(principals = subject.getPrincipals()).isEmpty()) {
            return subject.getPrincipals().iterator().next();
        }
        return null;
    }

    Class<?> loadClass(final Class<?> theClass, final String fqn) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                ClassLoader classLoader = theClass.getClassLoader();
                Class<?> clazz = PicketLinkAuthenticator.this.loadClass(classLoader, fqn);
                if (clazz == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                    clazz = PicketLinkAuthenticator.this.loadClass(classLoader, fqn);
                }
                return clazz;
            }
        });
    }

    Class<?> loadClass(final ClassLoader cl, final String fqn) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return cl.loadClass(fqn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
    }

    public static class Factory
    implements AuthenticationMechanismFactory {
        private final IdentityManager identityManager;

        public Factory(IdentityManager manager) {
            this.identityManager = manager;
        }

        public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
            Boolean needSubjectPrincipalSubstitution = Boolean.valueOf(properties.getOrDefault("need-subject-principal-substitution", "true"));
            String subjectInteractionClassName = properties.getOrDefault("subject-interaction-class-name", "org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkJBossSubjectInteraction");
            String securityDomain = properties.get("security-domain");
            return new PicketLinkAuthenticator(this.identityManager, needSubjectPrincipalSubstitution, subjectInteractionClassName, securityDomain);
        }
    }
}

