/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory;
import java.net.URL;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRJWT", length=5)
interface PrincipalLogging
extends BasicLogger {
    public static final PrincipalLogging log = (PrincipalLogging)Logger.getMessageLogger(PrincipalLogging.class, (String)PrincipalLogging.class.getPackage().getName());

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8000, value="getAudience failure")
    public void getAudienceFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8001, value="getGroups failure: ")
    public void getGroupsFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8002, value="getClaimValue failure for: %s")
    public void getGroupsFailure(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8003, value="replaceClaimValueWithJsonValue failure for: %s")
    public void replaceClaimValueWithJsonFailure(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8004, value="Token is invalid")
    public void tokenInvalid();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8005, value="Verification key is unresolvable")
    public void verificationKeyUnresolvable();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8006, value="Claim value at the path %s is not a String")
    public void claimAtPathIsNotAString(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8007, value="Claim value at the path %s is not an array of strings")
    public void claimAtPathIsNotAnArrayOfStrings(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8008, value="Claim value at the path %s is neither an array of strings nor string")
    public void claimAtPathIsNeitherAnArrayOfStringsNorString(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=8009, value="Updated groups to: %s")
    public void updatedGroups(List<String> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8010, value="Failed to access rolesMapping claim")
    public void failedToAccessRolesMappingClaim(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8011, value="No claim exists at the path %s at segment %s")
    public void claimNotFoundAtPathAtSegment(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8012, value="Claim value at the path %s is not a json object")
    public void claimValueIsNotAJson(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8013, value="No max TTL has been specified in configuration")
    public void noMaxTTLSpecified();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8014, value="Required claims %s are not present in the JWT")
    public void missingClaims(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8015, value="loadSpi, cl=%s, u=%s, sl=%s")
    public void loadSpi(ClassLoader var1, URL var2, ServiceLoader<JWTCallerPrincipalFactory> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8016, value="Multiple JWTCallerPrincipalFactory implementations found: %s and %s")
    public void multipleJWTCallerPrincipalFactoryFound(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8017, value="sl=%s, loaded=%s")
    public void currentSpi(ServiceLoader<JWTCallerPrincipalFactory> var1, JWTCallerPrincipalFactory var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8018, value="Failed to locate JWTCallerPrincipalFactory provider")
    public void failedToLocateJWTCallerPrincipalFactoryProvider(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8019, value="AuthContextInfo is: %s")
    public void authContextInfo(JWTAuthContextInfo var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8020, value="Failed to create a key from the HTTPS JWK Set")
    public void failedToCreateKeyFromJWKSet(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8021, value="JWK with a matching 'kid' is not available, refreshing HTTPS JWK Set")
    public void kidIsNotAvailableRefreshingJWKSet();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8022, value="Failed to refresh HTTPS JWK Set")
    public void failedToRefreshJWKSet(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8023, value="JWK with a matching 'kid' is not available but HTTPS JWK Set has been refreshed less than %d minutes ago, trying to create a key from the HTTPS JWK Set one more time")
    public void matchingKidIsNotAvailableButJWTSRefreshed(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8024, value="Trying to create a key from the HTTPS JWK Set after the refresh")
    public void tryCreateKeyFromJWKSAfterRefresh();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8025, value="Failed to create a key from the HTTPS JWK Set after the refresh")
    public void failedToCreateKeyFromJWKSAfterRefresh(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8026, value="Trying to create a key from the JWK(S)")
    public void tryCreateKeyFromJWKS();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8027, value="Failed to create a key from the JWK(S)")
    public void failedToCreateKeyFromJWKS(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8028, value="Invalid token 'kid' header: %s, expected: %s")
    public void invalidTokenKidHeader(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8029, value="Trying to load the keys from the HTTPS JWK(S)")
    public void tryLoadKeyFromJWKS();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8030, value="Checking if the key content is a JWK key or JWK key set")
    public void checkKeyContentIsJWKKeyOrJWKKeySet();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8031, value="Checking if the key content is a Base64URL encoded JWK key or JWK key set")
    public void checkKeyContentIsBase64EncodedJWKKeyOrJWKKeySet();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8032, value="Unable to decode content using Base64 decoder")
    public void unableToDecodeContentUsingBase64(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8033, value="Key has been created from the encoded JWK key or JWK key set")
    public void keyCreatedFromEncodedJWKKeyOrJWKKeySet();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8034, value="Key has been created from the JWK key or JWK key set")
    public void keyCreatedFromJWKKeyOrJWKKeySet();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8035, value="Checking if the key content is a Base64 encoded PEM key")
    public void checkKeyContentIsBase64EncodedPEMKey();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8036, value="Key has been created from the encoded PEM key")
    public void keyCreatedFromEncodedPEMKey();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8037, value="The key content is not a valid encoded PEM key")
    public void keyContentIsNotValidEncodedPEMKey(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8038, value="Checking if the key content is a Base64 encoded PEM certificate")
    public void checkKeyContentIsBase64EncodedPEMCertificate();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8039, value="PublicKey has been created from the encoded PEM certificate")
    public void publicKeyCreatedFromEncodedPEMCertificate();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8040, value="The key content is not a valid encoded PEM certificate")
    public void keyContentIsNotValidEncodedPEMCertificate(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8041, value="Decryption key is unresolvable")
    public void decryptionKeyUnresolvable();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8042, value="Encrypted token sequence is invalid")
    public void encryptedTokenSequenceInvalid();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8043, value="Trying to create a key from the HTTPS JWK(S)")
    public void tryCreateKeyFromHttpsJWKS();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8044, value="Encrypted token headers must contain a content type header")
    public void encryptedTokenMissingContentType();
}

