/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.jboss.resteasy.plugins.providers.multipart.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;

public class ContentIDUtils {
    public static final String CID_URL_SCHEME = "cid:";

    public static String generateContentID() {
        return ContentIDUtils.generateContentIDFromAddrSpec(ContentIDUtils.generateRFC822AddrSpec());
    }

    public static String generateContentIDFromAddrSpec(String addrSpec) {
        return "<" + addrSpec + ">";
    }

    public static String generateRFC822AddrSpec() {
        return UUID.randomUUID().toString() + "@resteasy-multipart";
    }

    public static String generateCidFromAddrSpec(String addrSpec) {
        String cid = CID_URL_SCHEME;
        try {
            cid = cid + URLEncoder.encode(addrSpec, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.urlEncoderDoesNotSupportUtf8(), e);
        }
        return cid;
    }

    public static String parseAddrSpecFromCid(String cid) {
        String addrSpec = cid.trim();
        if (addrSpec.startsWith(CID_URL_SCHEME)) {
            addrSpec = addrSpec.substring(CID_URL_SCHEME.length()).trim();
        }
        try {
            addrSpec = URLDecoder.decode(addrSpec, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.urlDecoderDoesNotSupportUtf8(), e);
        }
        return addrSpec;
    }

    public static String parseAddrSpecFromContentID(String contentID) {
        String addrSpec = contentID.trim();
        if (addrSpec.startsWith("<") && addrSpec.endsWith(">")) {
            addrSpec = addrSpec.substring(1, addrSpec.length() - 1).trim();
        }
        return addrSpec;
    }

    public static String convertCidToContentID(String cid) {
        return ContentIDUtils.generateContentIDFromAddrSpec(ContentIDUtils.parseAddrSpecFromCid(cid));
    }

    public static String convertContentIDToCid(String contentID) {
        return ContentIDUtils.generateCidFromAddrSpec(ContentIDUtils.parseAddrSpecFromContentID(contentID));
    }
}

