/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitsInApplication;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class JPADependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier JAVAX_PERSISTENCE_API_ID = ModuleIdentifier.create((String)"javax.persistence.api");
    private static final ModuleIdentifier JBOSS_AS_JPA_ID = ModuleIdentifier.create((String)"org.jboss.as.jpa");
    private static final ModuleIdentifier JBOSS_AS_JPA_SPI_ID = ModuleIdentifier.create((String)"org.jboss.as.jpa.spi");
    private static final ModuleIdentifier HIBERNATE_TRANSFORMER_ID = ModuleIdentifier.create((String)"org.hibernate.bytecodetransformer");
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String LIB_FOLDER = "lib";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, deploymentUnit, JAVAX_PERSISTENCE_API_ID, HIBERNATE_TRANSFORMER_ID);
        if (!JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        this.addDependency(moduleSpecification, moduleLoader, deploymentUnit, JBOSS_AS_JPA_ID, JBOSS_AS_JPA_SPI_ID);
        this.addPersistenceProviderModuleDependencies(phaseContext, moduleSpecification, moduleLoader);
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit deploymentUnit, ModuleIdentifier ... moduleIdentifiers) {
        for (ModuleIdentifier moduleIdentifier : moduleIdentifiers) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, true, false));
            JpaLogger.ROOT_LOGGER.debugf("added %s dependency to %s", moduleIdentifier, deploymentUnit.getName());
        }
    }

    private void addOptionalDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit deploymentUnit, ModuleIdentifier ... moduleIdentifiers) {
        for (ModuleIdentifier moduleIdentifier : moduleIdentifiers) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, true, false, false, false));
            JpaLogger.ROOT_LOGGER.debugf("added %s dependency to %s", moduleIdentifier, deploymentUnit.getName());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addPersistenceProviderModuleDependencies(DeploymentPhaseContext phaseContext, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        block9: {
            Collection components;
            PersistenceUnitsInApplication persistenceUnitsInApplication;
            block7: {
                DeploymentUnit deploymentUnit;
                block8: {
                    deploymentUnit = phaseContext.getDeploymentUnit();
                    int defaultProviderCount = 0;
                    HashSet<String> moduleDependencies = new HashSet<String>();
                    persistenceUnitsInApplication = (PersistenceUnitsInApplication)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachment(PersistenceUnitsInApplication.PERSISTENCE_UNITS_IN_APPLICATION);
                    for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
                        defaultProviderCount += this.loadPersistenceUnits(moduleSpecification, moduleLoader, deploymentUnit, moduleDependencies, holder);
                    }
                    if (defaultProviderCount > 0) {
                        moduleDependencies.add(Configuration.getDefaultProviderModuleName());
                        JpaLogger.ROOT_LOGGER.debugf("added (default provider) %s dependency to %s (since %d PU(s) didn't specify %s", new Object[]{Configuration.getDefaultProviderModuleName(), deploymentUnit.getName(), defaultProviderCount, "jboss.as.jpa.providerModule)"});
                    }
                    for (String dependency : moduleDependencies) {
                        this.addDependency(moduleSpecification, moduleLoader, deploymentUnit, ModuleIdentifier.fromString((String)dependency));
                    }
                    EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
                    components = eeModuleDescription.getComponentDescriptions();
                    boolean earSubDeploymentsAreInitializedInCustomOrder = false;
                    EarMetaData earConfig = null;
                    earConfig = (EarMetaData)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA);
                    boolean bl = earSubDeploymentsAreInitializedInCustomOrder = earConfig != null && earConfig.getInitializeInOrder() && earConfig.getModules().size() > 1;
                    if (!earSubDeploymentsAreInitializedInCustomOrder) break block7;
                    if (deploymentUnit.getParent() == null) break block8;
                    ArrayList<PersistenceUnitMetadata> collectPersistenceUnitsForCurrentDeploymentUnit = new ArrayList<PersistenceUnitMetadata>();
                    ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
                    ModuleMetaData moduleMetaData = (ModuleMetaData)deploymentRoot.getAttachment(org.jboss.as.ee.structure.Attachments.MODULE_META_DATA);
                    for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
                        if (holder == null || holder.getPersistenceUnits() == null) continue;
                        for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                            String moduleName = (String)pu.getContainingModuleName().get(pu.getContainingModuleName().size() - 1);
                            if (!moduleName.equals(moduleMetaData.getFileName())) continue;
                            JpaLogger.ROOT_LOGGER.tracef("Jakarta EE components in %s will depend on persistence unit %s", moduleName, pu.getScopedPersistenceUnitName());
                            collectPersistenceUnitsForCurrentDeploymentUnit.add(pu);
                        }
                    }
                    if (collectPersistenceUnitsForCurrentDeploymentUnit.isEmpty()) break block9;
                    JPADependencyProcessor.addPUServiceDependencyToComponents(components, new PersistenceUnitMetadataHolder(collectPersistenceUnitsForCurrentDeploymentUnit));
                    break block9;
                }
                List resourceRoots = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachmentList(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS);
                for (ResourceRoot resourceRoot : resourceRoots) {
                    if (SubDeploymentMarker.isSubDeployment((ResourceRoot)resourceRoot)) continue;
                    JPADependencyProcessor.addPUServiceDependencyToComponents(components, (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS));
                }
                break block9;
            }
            for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
                JPADependencyProcessor.addPUServiceDependencyToComponents(components, holder);
            }
        }
    }

    private static void addPUServiceDependencyToComponents(Collection<ComponentDescription> components, PersistenceUnitMetadataHolder holder) {
        if (components == null || components.isEmpty() || holder == null) {
            return;
        }
        for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
            String jpaContainerManaged = pu.getProperties().getProperty("jboss.as.jpa.managed");
            boolean deployPU = jpaContainerManaged == null ? true : Boolean.parseBoolean(jpaContainerManaged);
            if (!deployPU) continue;
            ServiceName puServiceName = PersistenceUnitServiceImpl.getPUServiceName(pu);
            for (ComponentDescription component : components) {
                JpaLogger.ROOT_LOGGER.debugf("Adding dependency on PU service %s for component %s", puServiceName, component.getComponentClassName());
                component.addDependency(puServiceName);
            }
        }
    }

    private int loadPersistenceUnits(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit deploymentUnit, Set<String> moduleDependencies, PersistenceUnitMetadataHolder holder) throws DeploymentUnitProcessingException {
        int defaultProviderCount = 0;
        if (holder != null) {
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                String providerModule = pu.getProperties().getProperty("jboss.as.jpa.providerModule");
                String adapterModule = pu.getProperties().getProperty("jboss.as.jpa.adapterModule");
                String adapterClass = pu.getProperties().getProperty("jboss.as.jpa.adapterClass");
                if (adapterModule != null) {
                    JpaLogger.ROOT_LOGGER.debugf("%s is configured to use adapter module '%s'", pu.getPersistenceUnitName(), adapterModule);
                    moduleDependencies.add(adapterModule);
                }
                deploymentUnit.putAttachment(JpaAttachments.ADAPTOR_CLASS_NAME, (Object)adapterClass);
                String provider = pu.getProperties().getProperty("jboss.as.jpa.providerModule");
                if (provider != null) {
                    if (provider.equals("application")) {
                        JpaLogger.ROOT_LOGGER.debugf("%s is configured to use application supplied persistence provider", pu.getPersistenceUnitName());
                        continue;
                    }
                    moduleDependencies.add(provider);
                    JpaLogger.ROOT_LOGGER.debugf("%s is configured to use provider module '%s'", pu.getPersistenceUnitName(), provider);
                    continue;
                }
                if ("org.hibernate.jpa.HibernatePersistenceProvider".equals(pu.getPersistenceProviderClassName())) {
                    ++defaultProviderCount;
                    continue;
                }
                String providerModuleName = Configuration.getProviderModuleNameFromProviderClassName(pu.getPersistenceProviderClassName());
                if (providerModuleName == null) continue;
                this.addOptionalDependency(moduleSpecification, moduleLoader, deploymentUnit, ModuleIdentifier.fromString((String)providerModuleName));
                JpaLogger.ROOT_LOGGER.debugf("%s is configured to use persistence provider '%s', adding an optional dependency on module '%s'", pu.getPersistenceUnitName(), pu.getPersistenceProviderClassName(), providerModuleName);
            }
        }
        return defaultProviderCount;
    }
}

