/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;

public class ExpiredBeanRemover<I, T>
implements BeanRemover<I, T> {
    private final BeanFactory<I, T> factory;
    private final ExpirationConfiguration<T> expiration;

    public ExpiredBeanRemover(BeanFactory<I, T> factory, ExpirationConfiguration<T> expiration) {
        this.factory = factory;
        this.expiration = expiration;
    }

    @Override
    public boolean remove(I id, RemoveListener<T> listener) {
        BeanEntry entry = (BeanEntry)this.factory.tryValue(id);
        if (entry != null) {
            if (entry.isExpired(this.expiration.getTimeout())) {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Removing expired bean %s", id);
                return this.factory.remove(id, listener);
            }
            return false;
        }
        return true;
    }
}

