/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.clustering.controller.FunctionExecutor;
import org.jboss.as.clustering.controller.FunctionExecutorRegistry;
import org.jboss.as.clustering.controller.ServiceValueCaptor;
import org.jboss.as.clustering.controller.ServiceValueExecutor;
import org.jboss.as.clustering.controller.ServiceValueRegistry;
import org.jboss.msc.service.ServiceName;

public class ServiceValueExecutorRegistry<T>
implements ServiceValueRegistry<T>,
FunctionExecutorRegistry<T> {
    private final Map<ServiceName, ServiceValueExecutor<T>> executors = new ConcurrentHashMap<ServiceName, ServiceValueExecutor<T>>();

    @Override
    public ServiceValueCaptor<T> add(ServiceName name) {
        ServiceValueExecutor executor = new ServiceValueExecutor(name);
        ServiceValueExecutor existing = this.executors.putIfAbsent(name, executor);
        return existing != null ? existing : executor;
    }

    @Override
    public ServiceValueCaptor<T> remove(ServiceName name) {
        return this.executors.remove(name);
    }

    @Override
    public FunctionExecutor<T> get(ServiceName name) {
        return this.executors.get(name);
    }
}

