/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.cipher.BaseCipher;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BaseGCMCipher
extends BaseCipher {
    protected Cipher.Mode mode;
    protected boolean initialized;
    protected CounterGCMParameterSpec parameters;
    protected SecretKey secretKey;

    public BaseGCMCipher(int ivsize, int authSize, int kdfSize, String algorithm, int keySize, String transformation, int blkSize) {
        super(ivsize, authSize, kdfSize, algorithm, keySize, transformation, blkSize);
    }

    @Override
    protected Cipher createCipherInstance(Cipher.Mode mode, byte[] key, byte[] iv) throws Exception {
        this.mode = mode;
        this.secretKey = new SecretKeySpec(key, this.getAlgorithm());
        this.parameters = new CounterGCMParameterSpec(this.getAuthenticationTagSize() * 8, iv);
        return SecurityUtils.getCipher(this.getTransformation());
    }

    protected Cipher getInitializedCipherInstance() throws Exception {
        Cipher cipher = this.getCipherInstance();
        if (!this.initialized) {
            cipher.init(this.mode == Cipher.Mode.Encrypt ? 1 : 2, (Key)this.secretKey, this.parameters);
            this.initialized = true;
        }
        return cipher;
    }

    public void updateAAD(byte[] data, int offset, int length) throws Exception {
        this.getInitializedCipherInstance().updateAAD(data, offset, length);
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) throws Exception {
        if (this.mode == Cipher.Mode.Decrypt) {
            inputLen += this.getAuthenticationTagSize();
        }
        Cipher cipher = this.getInitializedCipherInstance();
        cipher.doFinal(input, inputOffset, inputLen, input, inputOffset);
        this.parameters.incrementCounter();
        this.initialized = false;
    }

    protected static class CounterGCMParameterSpec
    extends GCMParameterSpec {
        protected final byte[] iv;
        protected final long initialCounter;

        protected CounterGCMParameterSpec(int tLen, byte[] src) {
            super(tLen, src);
            if (src.length != 12) {
                throw new IllegalArgumentException("GCM nonce must be 12 bytes, but given len=" + src.length);
            }
            this.iv = (byte[])src.clone();
            this.initialCounter = BufferUtils.getLong((byte[])this.iv, (int)(this.iv.length - 8), (int)8);
        }

        protected void incrementCounter() {
            int off = this.iv.length - 8;
            long counter = BufferUtils.getLong((byte[])this.iv, (int)off, (int)8);
            long newCounter = counter + 1L;
            if (newCounter == this.initialCounter) {
                throw new IllegalStateException("GCM IV would be reused");
            }
            BufferUtils.putLong((long)newCounter, (byte[])this.iv, (int)off, (int)8);
        }

        @Override
        public byte[] getIV() {
            return (byte[])this.iv.clone();
        }
    }
}

