/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.util.ArrayList;
import javax.ejb.TransactionAttribute;
import javax.jws.WebService;
import javax.transaction.Transactional;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.narayana.compensations.api.CancelOnFailure;
import org.jboss.narayana.compensations.api.Compensatable;
import org.jboss.narayana.compensations.api.CompensationScoped;
import org.jboss.narayana.compensations.api.TxCompensate;
import org.jboss.narayana.compensations.api.TxConfirm;
import org.jboss.narayana.compensations.api.TxLogged;

public class XTSDependenciesDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier XTS_MODULE = ModuleIdentifier.create((String)"org.jboss.xts");
    private static final Class[] COMPENSATABLE_ANNOTATIONS = new Class[]{Compensatable.class, CancelOnFailure.class, CompensationScoped.class, TxCompensate.class, TxConfirm.class, TxLogged.class};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        CompositeIndex compositeIndex = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        if (this.isCompensationAnnotationPresent(compositeIndex) || this.isTransactionalEndpointPresent(compositeIndex)) {
            this.addXTSModuleDependency(unit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private boolean isCompensationAnnotationPresent(CompositeIndex compositeIndex) {
        for (Class annotation : COMPENSATABLE_ANNOTATIONS) {
            if (compositeIndex.getAnnotations(DotName.createSimple((String)annotation.getName())).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isTransactionalEndpointPresent(CompositeIndex compositeIndex) {
        ArrayList annotations = new ArrayList();
        annotations.addAll(compositeIndex.getAnnotations(DotName.createSimple((String)Transactional.class.getName())));
        annotations.addAll(compositeIndex.getAnnotations(DotName.createSimple((String)TransactionAttribute.class.getName())));
        for (AnnotationInstance annotation : annotations) {
            ClassInfo classInfo;
            AnnotationTarget target = annotation.target();
            if (!(target instanceof ClassInfo) || (classInfo = (ClassInfo)target).annotations().get(DotName.createSimple((String)WebService.class.getName())) == null) continue;
            return true;
        }
        return false;
    }

    private void addXTSModuleDependency(DeploymentUnit unit) {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, XTS_MODULE, false, false, false, false));
    }
}

