/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.lang.ref.WeakReference;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitImpl;
import org.jboss.as.server.deployment.MountExplodedMarker;
import org.jboss.as.server.deployment.annotation.AnnotationIndexSupport;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayIndex;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.VirtualFile;

final class RootDeploymentUnitService
extends AbstractDeploymentUnitService {
    private final InjectedValue<DeploymentMountProvider> serverDeploymentRepositoryInjector = new InjectedValue();
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final InjectedValue<VirtualFile> contentsInjector = new InjectedValue();
    private final String name;
    private final String managementName;
    private final DeploymentUnit parent;
    private final DeploymentOverlayIndex deploymentOverlays;
    private final WeakReference<AnnotationIndexSupport> annotationIndexSupport;
    private final boolean isExplodedContent;

    public RootDeploymentUnitService(String name, String managementName, DeploymentUnit parent, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, Resource resource, CapabilityServiceSupport capabilityServiceSupport, DeploymentOverlayIndex deploymentOverlays, AnnotationIndexSupport annotationIndexSupport, boolean exploded) {
        super(registration, mutableRegistration, resource, capabilityServiceSupport);
        assert (name != null) : "name is null";
        this.name = name;
        this.managementName = managementName;
        this.parent = parent;
        this.deploymentOverlays = deploymentOverlays;
        this.annotationIndexSupport = new WeakReference<AnnotationIndexSupport>(annotationIndexSupport);
        this.isExplodedContent = exploded;
    }

    @Override
    protected DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry registry) {
        DeploymentUnitImpl deploymentUnit = new DeploymentUnitImpl(this.parent, this.name, registry);
        deploymentUnit.putAttachment(Attachments.RUNTIME_NAME, this.name);
        deploymentUnit.putAttachment(Attachments.MANAGEMENT_NAME, this.managementName);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_CONTENTS, this.contentsInjector.getValue());
        deploymentUnit.putAttachment(DeploymentResourceSupport.REGISTRATION_ATTACHMENT, this.registration);
        deploymentUnit.putAttachment(DeploymentResourceSupport.MUTABLE_REGISTRATION_ATTACHMENT, this.mutableRegistration);
        deploymentUnit.putAttachment(DeploymentResourceSupport.DEPLOYMENT_RESOURCE, this.resource);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT, new DeploymentResourceSupport(deploymentUnit));
        deploymentUnit.putAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT, this.capabilityServiceSupport);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_OVERLAY_INDEX, this.deploymentOverlays);
        deploymentUnit.putAttachment(Attachments.PATH_MANAGER, this.pathManagerInjector.getValue());
        deploymentUnit.putAttachment(Attachments.ANNOTATION_INDEX_SUPPORT, this.annotationIndexSupport);
        if (this.isExplodedContent) {
            MountExplodedMarker.setMountExploded(deploymentUnit);
        }
        deploymentUnit.putAttachment(Attachments.SERVER_DEPLOYMENT_REPOSITORY, this.serverDeploymentRepositoryInjector.getValue());
        return deploymentUnit;
    }

    Injector<DeploymentMountProvider> getServerDeploymentRepositoryInjector() {
        return this.serverDeploymentRepositoryInjector;
    }

    InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    InjectedValue<VirtualFile> getContentsInjector() {
        return this.contentsInjector;
    }
}

