/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ExtensionXml;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.SocketBindingGroupResourceDefinition;
import org.jboss.as.domain.controller.resources.HostExcludeResourceDefinition;
import org.jboss.as.domain.controller.resources.ProfileResourceDefinition;
import org.jboss.as.domain.controller.resources.ServerGroupResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.parsing.AccessControlXml;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.as.host.controller.parsing.DomainSocketBindingsXml;
import org.jboss.as.host.controller.parsing.JvmXml;
import org.jboss.as.server.parsing.CommonXml;
import org.jboss.as.server.parsing.SocketBindingsXml;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;

final class DomainXml_13
extends CommonXml
implements ManagementXmlDelegate {
    private final AccessControlXml accessControlXml;
    private final Namespace namespace;
    private final ExtensionXml extensionXml;
    private final ExtensionRegistry extensionRegistry;

    DomainXml_13(ExtensionXml extensionXml, ExtensionRegistry extensionRegistry, Namespace namespace) {
        super((SocketBindingsXml)new DomainSocketBindingsXml());
        this.accessControlXml = AccessControlXml.newInstance((Namespace)namespace);
        this.extensionXml = extensionXml;
        this.extensionRegistry = extensionRegistry;
        this.namespace = namespace;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> nodes) throws XMLStreamException {
        if (Element.forName((String)reader.getLocalName()) != Element.DOMAIN) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        for (Namespace current : Namespace.domainValues()) {
            if (!this.namespace.equals((Object)current)) continue;
            this.readDomainElement(reader, new ModelNode(), nodes);
            return;
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private void readDomainElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        this.readDomainElementAttributes(reader, address, list);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, this.namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, this.namespace, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, this.namespace, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.MANAGEMENT) {
            ManagementXml managementXml = ManagementXml.newInstance((Namespace)this.namespace, (ManagementXmlDelegate)this, (boolean)true);
            managementXml.parseManagement(reader, address, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.PROFILES) {
            this.parseProfiles(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, this.namespace, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            this.parseDomainSocketBindingGroups(reader, address, list, interfaceNames);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, this.namespace, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.DEPLOYMENT_OVERLAYS) {
            this.parseDeploymentOverlays(reader, this.namespace, new ModelNode(), list, true, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.SERVER_GROUPS) {
            this.parseServerGroups(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.HOST_EXCLUDES) {
            this.parseHostExcludes(reader, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.MANAGEMENT_CLIENT_CONTENT) {
            this.parseManagementClientContent(reader, address, this.namespace, list);
            ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        } else if (element == null) {
            this.initializeRolloutPlans(address, list);
        } else {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readDomainElementAttributes(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        boolean hasDomainOrg = false;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Namespace ns = Namespace.forUri((String)reader.getAttributeNamespace(i));
            switch (ns) {
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block12;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case NAME: {
                            ModelNode op = new ModelNode();
                            op.get("operation").set("write-attribute");
                            op.get("name").set("name");
                            op.get("value").set(ParseUtils.parsePossibleExpression((String)reader.getAttributeValue(i)));
                            list.add(op);
                            continue block12;
                        }
                        case ORGANIZATION: {
                            if (hasDomainOrg) {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                        case DOMAIN_ORGANIZATION: {
                            ModelNode op = new ModelNode();
                            op.get("operation").set("write-attribute");
                            op.get("name").set("domain-organization");
                            op.get("value").set(ParseUtils.parsePossibleExpression((String)reader.getAttributeValue(i)));
                            list.add(op);
                            hasDomainOrg = true;
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseDomainSocketBindingGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> interfaces) throws XMLStreamException {
        HashSet<String> uniqueGroupNames = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING_GROUP: {
                    this.parseSocketBindingGroup(reader, interfaces, address, list, uniqueGroupNames);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSocketBindingGroup(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates, HashSet<String> uniqueGroupNames) throws XMLStreamException {
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        String socketBindingGroupName = null;
        String defaultInterface = null;
        int count = reader.getAttributeCount();
        ModelNode add = Util.createAddOperation();
        block9: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    socketBindingGroupName = reader.getAttributeValue(i);
                    if (!uniqueGroupNames.add(socketBindingGroupName)) {
                        throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("socket-binding-group", socketBindingGroupName, reader.getLocation());
                    }
                    add.get("address").set(address.clone().add("socket-binding-group", socketBindingGroupName));
                    continue block9;
                }
                case DEFAULT_INTERFACE: {
                    defaultInterface = reader.getAttributeValue(i);
                    SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(defaultInterface, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case INCLUDES: {
                    for (String val : reader.getListAttributeValue(i)) {
                        SocketBindingGroupResourceDefinition.INCLUDES.parseAndAddParameterElement(val, add, (XMLStreamReader)reader);
                    }
                    HashSet<String> includes = new HashSet<String>();
                    for (ModelNode include : add.get("includes").asList()) {
                        if (includes.add(include.asString())) continue;
                        throw DomainControllerLogger.ROOT_LOGGER.duplicateSocketBindingGroupInclude(include.asString());
                    }
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (socketBindingGroupName == null || defaultInterface == null) {
            HashSet<String> missing = new HashSet<String>();
            if (socketBindingGroupName == null) {
                missing.add(Attribute.NAME.getLocalName());
            }
            if (defaultInterface == null) {
                missing.add(Attribute.DEFAULT_INTERFACE.getLocalName());
            }
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missing);
        }
        if (add.get(SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.getName()).getType() != ModelType.EXPRESSION && !interfaces.contains(defaultInterface)) {
            throw ControllerLogger.ROOT_LOGGER.unknownInterface(defaultInterface, Attribute.DEFAULT_INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
        }
        updates.add(add);
        ModelNode groupAddress = add.get("address");
        block12: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block12;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
                case OUTBOUND_SOCKET_BINDING: {
                    String bindingName = this.parseOutboundSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block12;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element serverGroup = Element.forName((String)reader.getLocalName());
            if (Element.SERVER_GROUP != serverGroup) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ModelNode groupAddOp = new ModelNode();
            groupAddOp.get("operation").set("add");
            groupAddOp.get("address");
            String name = null;
            EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.PROFILE);
            int count = reader.getAttributeCount();
            block13: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                required.remove(attribute);
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)value);
                        }
                        name = value;
                        continue block13;
                    }
                    case PROFILE: {
                        ServerGroupResourceDefinition.PROFILE.parseAndSetParameter(value, groupAddOp, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case MANAGEMENT_SUBSYSTEM_ENDPOINT: {
                        ServerGroupResourceDefinition.MANAGEMENT_SUBSYSTEM_ENDPOINT.parseAndSetParameter(value, groupAddOp, (XMLStreamReader)reader);
                        continue block13;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            ModelNode groupAddress = new ModelNode().set(address);
            groupAddress.add("server-group", name);
            groupAddOp.get("address").set(groupAddress);
            list.add(groupAddOp);
            boolean sawDeployments = false;
            block14: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                Element element = Element.forName((String)reader.getLocalName());
                switch (element) {
                    case JVM: {
                        JvmXml.parseJvm(reader, groupAddress, this.namespace, list, new HashSet<String>(), false);
                        continue block14;
                    }
                    case SOCKET_BINDING_GROUP: {
                        this.parseSocketBindingGroupRef(reader, groupAddOp, ServerGroupResourceDefinition.SOCKET_BINDING_GROUP, ServerGroupResourceDefinition.SOCKET_BINDING_PORT_OFFSET, ServerGroupResourceDefinition.SOCKET_BINDING_DEFAULT_INTERFACE);
                        continue block14;
                    }
                    case DEPLOYMENTS: {
                        if (sawDeployments) {
                            throw ControllerLogger.ROOT_LOGGER.alreadyDefined(element.getLocalName(), reader.getLocation());
                        }
                        sawDeployments = true;
                        ArrayList deployments = new ArrayList();
                        this.parseDeployments(reader, groupAddress, this.namespace, deployments, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME, Attribute.ENABLED), Collections.emptySet(), true);
                        list.addAll(deployments);
                        continue block14;
                    }
                    case DEPLOYMENT_OVERLAYS: {
                        this.parseDeploymentOverlays(reader, this.namespace, groupAddress, list, false, true);
                        continue block14;
                    }
                    case SYSTEM_PROPERTIES: {
                        this.parseSystemProperties(reader, groupAddress, this.namespace, list, false);
                        continue block14;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseProfiles(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (Element.PROFILE != element) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String name = null;
            int count = reader.getAttributeCount();
            ModelNode profile = Util.createAddOperation();
            block8: for (int i = 0; i < count; ++i) {
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = reader.getAttributeValue(i);
                        if (!names.add(name)) {
                            throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("profile", name, reader.getLocation());
                        }
                        profile.get("address").set(address.clone().add("profile", name));
                        continue block8;
                    }
                    case INCLUDES: {
                        Object val2;
                        for (Object val2 : reader.getListAttributeValue(i)) {
                            ProfileResourceDefinition.INCLUDES.parseAndAddParameterElement((String)val2, profile, (XMLStreamReader)reader);
                        }
                        HashSet<String> includes = new HashSet<String>();
                        val2 = profile.get("includes").asList().iterator();
                        while (val2.hasNext()) {
                            ModelNode include = (ModelNode)val2.next();
                            if (includes.add(include.asString())) continue;
                            throw DomainControllerLogger.ROOT_LOGGER.duplicateProfileInclude(include.asString());
                        }
                        continue block8;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
            }
            list.add(profile);
            LinkedHashMap profileOps = new LinkedHashMap();
            block11: while (reader.nextTag() != 2) {
                Namespace ns = Namespace.forUri((String)reader.getNamespaceURI());
                switch (ns) {
                    case UNKNOWN: {
                        if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        String namespace = reader.getNamespaceURI();
                        if (profileOps.containsKey(namespace)) {
                            throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("subsystem", name, reader.getLocation());
                        }
                        ArrayList subsystems = new ArrayList();
                        reader.handleAny(subsystems);
                        profileOps.put(namespace, subsystems);
                        continue block11;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Set completionHandlers = this.extensionRegistry.getProfileParsingCompletionHandlers();
            for (ProfileParsingCompletionHandler completionHandler : completionHandlers) {
                completionHandler.handleProfileParsingCompletion(profileOps, list);
            }
            for (ArrayList subsystems : profileOps.values()) {
                for (ModelNode update : subsystems) {
                    ModelNode subsystemAddress = address.clone().set(address).add("profile", name);
                    for (Property path : update.get("address").asPropertyList()) {
                        subsystemAddress.add(path.getName(), path.getValue().asString());
                    }
                    update.get("address").set(subsystemAddress);
                    list.add(update);
                }
            }
        }
    }

    private void parseManagementClientContent(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean rolloutPlansAdded = false;
        block3: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLLOUT_PLANS: {
                    this.parseRolloutPlans(reader, address, list);
                    rolloutPlansAdded = true;
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!rolloutPlansAdded) {
            this.initializeRolloutPlans(address, list);
        }
    }

    private void parseRolloutPlans(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String hash = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.SHA1.getLocalName());
        ModelNode addAddress = address.clone().add("management-client-content", "rollout-plans");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)addAddress);
        try {
            addOp.get("hash").set(HashUtil.hexStringToByteArray((String)hash));
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.invalidSha1Value((Throwable)e, hash, Attribute.SHA1.getLocalName(), reader.getLocation());
        }
        list.add(addOp);
    }

    private void initializeRolloutPlans(ModelNode address, List<ModelNode> list) {
        ModelNode addAddress = address.clone().add("management-client-content", "rollout-plans");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)addAddress);
        list.add(addOp);
    }

    public boolean parseAccessControl(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operationsList) throws XMLStreamException {
        ModelNode accAuthzAddr = address.clone().add("access", "authorization");
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ModelNode op;
            ModelNode provider;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attribute == Attribute.PROVIDER) {
                provider = AccessAuthorizationResourceDefinition.PROVIDER.parse(value, (XMLStreamReader)reader);
                op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PROVIDER.getName(), (ModelNode)provider);
                operationsList.add(op);
                continue;
            }
            if (attribute == Attribute.USE_IDENTITY_ROLES) {
                ModelNode useIdentityRoles = AccessAuthorizationResourceDefinition.USE_IDENTITY_ROLES.parse(value, (XMLStreamReader)reader);
                op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.USE_IDENTITY_ROLES.getName(), (ModelNode)useIdentityRoles);
                operationsList.add(op);
                continue;
            }
            if (attribute == Attribute.PERMISSION_COMBINATION_POLICY) {
                provider = AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.parse(value, (XMLStreamReader)reader);
                op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName(), (ModelNode)provider);
                operationsList.add(op);
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLE_MAPPING: {
                    this.accessControlXml.parseAccessControlRoleMapping(reader, accAuthzAddr, operationsList);
                    continue block7;
                }
                case SERVER_GROUP_SCOPED_ROLES: {
                    this.accessControlXml.parseServerGroupScopedRoles(reader, accAuthzAddr, operationsList);
                    continue block7;
                }
                case HOST_SCOPED_ROLES: {
                    this.accessControlXml.parseHostScopedRoles(reader, accAuthzAddr, operationsList);
                    continue block7;
                }
                case CONSTRAINTS: {
                    this.accessControlXml.parseAccessControlConstraints(reader, accAuthzAddr, operationsList);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return true;
    }

    private void parseHostExcludes(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case HOST_EXCLUDE: {
                    this.parseHostExclude(reader, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseHostExclude(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode addOp = Util.createAddOperation((PathAddress)PathAddress.EMPTY_ADDRESS);
        String name = null;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attribute == Attribute.NAME) {
                name = value;
                addOp.get("address").set(PathAddress.pathAddress((String)"host-exclude", (String)name).toModelNode());
                continue;
            }
            if (attribute == Attribute.ACTIVE_SERVER_GROUPS) {
                HostExcludeResourceDefinition.ACTIVE_SERVER_GROUPS.getParser().parseAndSetParameter(HostExcludeResourceDefinition.ACTIVE_SERVER_GROUPS, value, addOp, (XMLStreamReader)reader);
                continue;
            }
            if (attribute == Attribute.ACTIVE_SOCKET_BINDING_GROUPS) {
                HostExcludeResourceDefinition.ACTIVE_SOCKET_BINDING_GROUPS.getParser().parseAndSetParameter(HostExcludeResourceDefinition.ACTIVE_SOCKET_BINDING_GROUPS, value, addOp, (XMLStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        boolean sawMapping = false;
        ModelNode extensions = new ModelNode();
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case HOST_RELEASE: {
                    if (sawMapping) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    sawMapping = true;
                    this.parseHostRelease(reader, addOp);
                    continue block9;
                }
                case HOST_API_VERSION: {
                    if (sawMapping) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    sawMapping = true;
                    this.parseHostApiVersion(reader, addOp);
                    continue block9;
                }
                case EXCLUDED_EXTENSIONS: {
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    block10: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                        Element element1 = Element.forName((String)reader.getLocalName());
                        switch (element1) {
                            case EXTENSION: {
                                int attrcount = reader.getAttributeCount();
                                for (int i = 0; i < attrcount; ++i) {
                                    String value = reader.getAttributeValue(i);
                                    if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                                    if (attribute != Attribute.MODULE) {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                    extensions.add(value);
                                }
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                continue block10;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (extensions.isDefined()) {
            addOp.get(HostExcludeResourceDefinition.EXCLUDED_EXTENSIONS.getName()).set(extensions);
        }
        if (!sawMapping) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.HOST_RELEASE, Element.HOST_API_VERSION));
        }
        list.add(addOp);
    }

    private void parseHostRelease(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean sawId = false;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attribute != Attribute.ID) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            sawId = true;
            HostExcludeResourceDefinition.HOST_RELEASE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
        }
        if (!sawId) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.ID.getLocalName()});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseHostApiVersion(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.MAJOR_VERSION, Attribute.MINOR_VERSION);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attribute == Attribute.MAJOR_VERSION) {
                required.remove(attribute);
                HostExcludeResourceDefinition.MANAGEMENT_MAJOR_VERSION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                continue;
            }
            if (attribute == Attribute.MINOR_VERSION) {
                required.remove(attribute);
                HostExcludeResourceDefinition.MANAGEMENT_MINOR_VERSION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                continue;
            }
            if (attribute == Attribute.MICRO_VERSION) {
                HostExcludeResourceDefinition.MANAGEMENT_MICRO_VERSION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

