/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;
import org.wildfly.microprofile.reactive.messaging.common.ReactiveMessagingAttachments;
import org.wildfly.microprofile.reactive.messaging.config.ReactiveMessagingConfigSource;
import org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context.ElytronSSLContextRegistry;
import org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context.WildFlyKafkaSSLEngineFactory;
import org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context._private.MicroProfileReactiveMessagingKafkaLogger;

class ReactiveMessagingSslConfigProcessor
implements DeploymentUnitProcessor {
    private static final String RM_KAFKA_GLOBAL_PROPERTY_PREFIX = "mp.messaging.connector.smallrye-kafka.";
    private static final String RM_INCOMING_PROPERTY_PREFIX = "mp.messaging.outgoing.";
    private static final String RM_OUTGOING_PROPERTY_PREFIX = "mp.messaging.incoming.";
    static final String SSL_CONTEXT_PROPERTY_SUFFIX = "wildfly.elytron.ssl.context";
    private static final String SSL_ENGINE_FACTORY_CLASS = "ssl.engine.factory.class";
    private static final AttachmentKey<Object> DEPLOYMENT_ATTACHMENT_KEY = AttachmentKey.create(Object.class);

    ReactiveMessagingSslConfigProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!this.isReactiveMessagingDeployment(deploymentUnit)) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        Config config = ConfigProviderResolver.instance().getConfig((ClassLoader)module.getClassLoader());
        HashMap<String, String> addedProperties = new HashMap<String, String>();
        HashSet<ServiceName> mscDependencies = new HashSet<ServiceName>();
        for (String propertyName : config.getPropertyNames()) {
            if (!propertyName.endsWith(SSL_CONTEXT_PROPERTY_SUFFIX)) continue;
            String propertyValue = (String)config.getValue(propertyName, String.class);
            String prefix = null;
            if (propertyName.equals("mp.messaging.connector.smallrye-kafka.wildfly.elytron.ssl.context")) {
                prefix = RM_KAFKA_GLOBAL_PROPERTY_PREFIX;
            } else if (propertyName.startsWith(RM_INCOMING_PROPERTY_PREFIX) || propertyName.startsWith(RM_OUTGOING_PROPERTY_PREFIX)) {
                prefix = propertyName.substring(0, propertyName.indexOf(SSL_CONTEXT_PROPERTY_SUFFIX));
            }
            if (prefix == null) continue;
            MicroProfileReactiveMessagingKafkaLogger.LOGGER.foundPropertyUsingElytronClientSSLContext(propertyName, propertyValue);
            if (!ElytronSSLContextRegistry.isSSLContextInstalled(propertyValue)) {
                throw MicroProfileReactiveMessagingKafkaLogger.LOGGER.noElytronClientSSLContext(propertyValue);
            }
            mscDependencies.add(ElytronSSLContextRegistry.getSSLContextName(propertyValue));
            addedProperties.put(prefix + SSL_ENGINE_FACTORY_CLASS, WildFlyKafkaSSLEngineFactory.class.getName());
        }
        if (addedProperties.size() > 0) {
            ReactiveMessagingConfigSource.addProperties((Config)config, addedProperties);
            for (ServiceName svcName : mscDependencies) {
                phaseContext.addDeploymentDependency(svcName, DEPLOYMENT_ATTACHMENT_KEY);
            }
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }

    private boolean isReactiveMessagingDeployment(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.hasAttachment(ReactiveMessagingAttachments.IS_REACTIVE_MESSAGING_DEPLOYMENT)) {
            Boolean isRm = (Boolean)deploymentUnit.getAttachment(ReactiveMessagingAttachments.IS_REACTIVE_MESSAGING_DEPLOYMENT);
            return isRm;
        }
        return false;
    }
}

