/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.parsing.Element;

public class GlobalSecurityConfiguration
implements ConfigurationInfo {
    private final GlobalAuthorizationConfiguration authorization;
    public static final AttributeDefinition<Integer> CACHE_SIZE = AttributeDefinition.builder((String)"securityCacheSize", (Object)1000).build();
    public static final AttributeDefinition<Long> CACHE_TIMEOUT = AttributeDefinition.builder((String)"securityCacheTimeout", (Object)TimeUnit.MINUTES.toMillis(5L)).build();
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SECURITY.getLocalName());
    private final List<ConfigurationInfo> subElements;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalSecurityConfiguration.class, new AttributeDefinition[]{CACHE_SIZE, CACHE_TIMEOUT});
    }

    public GlobalSecurityConfiguration(GlobalAuthorizationConfiguration authorization, AttributeSet attributes) {
        this.authorization = authorization;
        this.attributes = attributes;
        this.subElements = Collections.singletonList(authorization);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public GlobalAuthorizationConfiguration authorization() {
        return this.authorization;
    }

    public long securityCacheSize() {
        return ((Integer)this.attributes.attribute(CACHE_SIZE).get()).intValue();
    }

    public long securityCacheTimeout() {
        return (Long)this.attributes.attribute(CACHE_TIMEOUT).get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSecurityConfiguration that = (GlobalSecurityConfiguration)o;
        return Objects.equals(this.authorization, that.authorization) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.authorization, this.attributes);
    }

    public String toString() {
        return "GlobalSecurityConfiguration{authorization=" + this.authorization + ", attributes=" + this.attributes + '}';
    }
}

