/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import java.util.function.UnaryOperator;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.AttributeValueTranslator;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.clustering.service.UnaryRequirement;

public abstract class JDBCStoreResourceDefinition
extends StoreResourceDefinition {
    static final PathElement PATH = JDBCStoreResourceDefinition.pathElement("jdbc");
    static final AttributeTranslation DATA_SOURCE_TRANSLATION = new AttributeTranslation(){

        public org.jboss.as.clustering.controller.Attribute getTargetAttribute() {
            return Attribute.DATA_SOURCE;
        }

        public AttributeValueTranslator getReadTranslator() {
            return (context, value) -> {
                String poolName = value.asString();
                PathAddress address = context.getCurrentAddress();
                PathAddress rootAddress = address.subAddress(0, address.size() - 4);
                PathAddress subsystemAddress = rootAddress.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
                Resource subsystem = context.readResourceFromRoot(subsystemAddress);
                for (String type : Arrays.asList("data-source", "xa-data-source")) {
                    Resource resource = subsystem.getChild(PathElement.pathElement((String)type, (String)poolName));
                    if (resource == null) continue;
                    return resource.getModel().get("jndi-name");
                }
                throw InfinispanLogger.ROOT_LOGGER.dataSourceNotFound(poolName);
            };
        }

        public AttributeValueTranslator getWriteTranslator() {
            return (context, value) -> {
                String jndiName = value.asString();
                PathAddress address = context.getCurrentAddress();
                PathAddress rootAddress = address.subAddress(0, address.size() - 4);
                PathAddress subsystemAddress = rootAddress.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
                Resource subsystem = context.readResourceFromRoot(subsystemAddress);
                for (String type : Arrays.asList("data-source", "xa-data-source")) {
                    if (!subsystem.hasChildren(type)) continue;
                    for (Resource.ResourceEntry entry : subsystem.getChildren(type)) {
                        ModelNode model = entry.getModel();
                        if (!model.get("jndi-name").asString().equals(jndiName)) continue;
                        return new ModelNode(entry.getName());
                    }
                }
                throw InfinispanLogger.ROOT_LOGGER.dataSourceJndiNameNotFound(jndiName);
            };
        }
    };

    JDBCStoreResourceDefinition(PathElement path, PathElement legacyPath, ResourceDescriptionResolver resolver, UnaryOperator<ResourceDescriptor> configurator) {
        super(path, legacyPath, resolver, new ResourceDescriptorConfigurator(configurator));
    }

    public ResourceServiceConfigurator createServiceConfigurator(PathAddress address) {
        return new JDBCStoreServiceConfigurator(address);
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addAttributes(Attribute.class).addAttributeTranslation((org.jboss.as.clustering.controller.Attribute)DeprecatedAttribute.DATASOURCE, DATA_SOURCE_TRANSLATION);
        }
    }

    static class TableAttributeTransformation
    implements UnaryOperator<OperationStepHandler> {
        private final org.jboss.as.clustering.controller.Attribute attribute;
        private final PathElement path;

        TableAttributeTransformation(org.jboss.as.clustering.controller.Attribute attribute, PathElement path) {
            this.attribute = attribute;
            this.path = path;
        }

        @Override
        public OperationStepHandler apply(OperationStepHandler handler) {
            return (context, operation) -> {
                if (operation.hasDefined(this.attribute.getName())) {
                    ModelNode addTableOperation = Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{this.path}));
                    ModelNode parameters = operation.get(this.attribute.getName());
                    for (Property parameter : parameters.asPropertyList()) {
                        addTableOperation.get(parameter.getName()).set(parameter.getValue());
                    }
                    context.addStep(addTableOperation, context.getResourceRegistration().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{this.path}), "add"), context.getCurrentStage());
                }
                handler.execute(context, operation);
            };
        }

        public UnaryOperator<OperationStepHandler> andThen(UnaryOperator<OperationStepHandler> after) {
            return handler -> (OperationStepHandler)after.apply(this.apply((OperationStepHandler)handler));
        }
    }

    static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        DATASOURCE("datasource", ModelType.STRING, InfinispanModel.VERSION_4_0_0){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true)).setRequired(false);
            }
        };

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, InfinispanModel deprecation) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setDeprecated(deprecation.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        DATA_SOURCE("data-source", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setRequired(true)).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((Capability)StoreResourceDefinition.Capability.PERSISTENCE, (UnaryRequirement)CommonUnaryRequirement.DATA_SOURCE))).setAlternatives(new String[]{DeprecatedAttribute.DATASOURCE.getName()});
            }
        }
        ,
        DIALECT("dialect", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true)).setRequired(false)).setValidator((ParameterValidator)new EnumValidator(DatabaseType.class));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply(new SimpleAttributeDefinitionBuilder(name, type).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

