/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupHandler;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.servlet.ServletContext;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.ActiveSessionStatistics;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.undertow.IdentifierFactoryAdapter;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManager;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerConfiguration;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.RecordableInactiveSessionStatistics;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionExpirationListener;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DistributableSessionManagerFactory
implements io.undertow.servlet.api.SessionManagerFactory {
    private static final String ALLOW_ORPHAN_SESSION_PROPERTY = "jboss.web.allow-orphan-session";
    private final SessionManagerFactory<ServletContext, Map<String, Object>, Batch> factory;
    private final SessionManagerFactoryConfiguration config;
    private final SessionListeners listeners = new SessionListeners();

    public DistributableSessionManagerFactory(SessionManagerFactory<ServletContext, Map<String, Object>, Batch> factory, SessionManagerFactoryConfiguration config) {
        this.factory = factory;
        this.config = config;
    }

    public SessionManager createSessionManager(final Deployment deployment) {
        final DeploymentInfo info = deployment.getDeploymentInfo();
        boolean statisticsEnabled = info.getMetricsCollector() != null;
        final RecordableInactiveSessionStatistics inactiveSessionStatistics = statisticsEnabled ? new RecordableInactiveSessionStatistics() : null;
        final IdentifierFactoryAdapter factory = new IdentifierFactoryAdapter(info.getSessionIdGenerator());
        final UndertowSessionExpirationListener expirationListener = new UndertowSessionExpirationListener(deployment, this.listeners);
        SessionManagerConfiguration<ServletContext> configuration = new SessionManagerConfiguration<ServletContext>(){

            public ServletContext getServletContext() {
                return deployment.getServletContext();
            }

            public IdentifierFactory<String> getIdentifierFactory() {
                return factory;
            }

            public SessionExpirationListener getExpirationListener() {
                return expirationListener;
            }

            public Recordable<ImmutableSessionMetaData> getInactiveSessionRecorder() {
                return inactiveSessionStatistics;
            }
        };
        final org.wildfly.clustering.web.session.SessionManager manager = this.factory.createSessionManager((SessionManagerConfiguration)configuration);
        final Batcher batcher = manager.getBatcher();
        info.addThreadSetupAction(new ThreadSetupHandler(){

            public <T, C> ThreadSetupHandler.Action<T, C> create(final ThreadSetupHandler.Action<T, C> action) {
                return new ThreadSetupHandler.Action<T, C>(){

                    public T call(HttpServerExchange exchange, C context) throws Exception {
                        Batch batch = batcher.suspendBatch();
                        try (BatchContext ctx = batcher.resumeBatch(batch);){
                            Object object = action.call(exchange, context);
                            return object;
                        }
                    }
                };
            }
        });
        final SessionListeners listeners = this.listeners;
        final DistributableSessionManagerStatistics statistics = inactiveSessionStatistics != null ? new DistributableSessionManagerStatistics((ActiveSessionStatistics)manager, inactiveSessionStatistics, this.config.getMaxActiveSessions()) : null;
        DistributableSessionManager result = new DistributableSessionManager(new DistributableSessionManagerConfiguration(){

            @Override
            public String getDeploymentName() {
                return info.getDeploymentName();
            }

            @Override
            public org.wildfly.clustering.web.session.SessionManager<Map<String, Object>, Batch> getSessionManager() {
                return manager;
            }

            @Override
            public SessionListeners getSessionListeners() {
                return listeners;
            }

            @Override
            public RecordableSessionManagerStatistics getStatistics() {
                return statistics;
            }

            @Override
            public boolean isOrphanSessionAllowed() {
                return (Boolean)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return Boolean.getBoolean(DistributableSessionManagerFactory.ALLOW_ORPHAN_SESSION_PROPERTY);
                    }
                });
            }
        });
        result.setDefaultSessionTimeout((int)this.config.getDefaultSessionTimeout().getSeconds());
        return result;
    }
}

