/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.adduser.AbstractValidationState;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConfirmationChoice;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.PreModificationState;
import org.jboss.as.domain.management.security.adduser.PromptNewUserState;
import org.jboss.as.domain.management.security.adduser.PromptPasswordState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;

public class ValidateUserState
extends AbstractValidationState {
    private static final String[] BAD_USER_NAMES = new String[]{"admin", "administrator", "root"};
    private static final char[] VALID_PUNCTUATION;
    private static final String VALID_SYMBOLS;
    private final StateValues stateValues;
    private final ConsoleWrapper theConsole;

    public ValidateUserState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    protected Collection<State> getValidationStates() {
        ArrayList<State> validationStates = new ArrayList<State>(3);
        validationStates.add(this.getValidCharactersState());
        validationStates.add(this.getDuplicateCheckState());
        validationStates.add(this.getCommonNamesCheckState());
        return validationStates;
    }

    @Override
    protected State getSuccessState() {
        return new PromptPasswordState(this.theConsole, this.stateValues, false);
    }

    private State getRetryState() {
        return this.stateValues.isSilentOrNonInteractive() ? null : new PromptNewUserState(this.theConsole, this.stateValues);
    }

    private State getValidCharactersState() {
        return new State(){

            @Override
            public State execute() {
                for (char currentChar : ValidateUserState.this.stateValues.getUserName().toCharArray()) {
                    if (this.isValidPunctuation(currentChar) || this.isValidLetter(currentChar) || Character.isDigit(currentChar)) continue;
                    return new ErrorState(ValidateUserState.this.theConsole, DomainManagementLogger.ROOT_LOGGER.usernameNotAlphaNumeric(VALID_SYMBOLS), ValidateUserState.this.getRetryState(), ValidateUserState.this.stateValues);
                }
                return ValidateUserState.this;
            }

            private boolean isValidPunctuation(char currentChar) {
                return Arrays.binarySearch(VALID_PUNCTUATION, currentChar) >= 0;
            }

            private boolean isValidLetter(char c) {
                return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
            }
        };
    }

    private State getDuplicateCheckState() {
        return new State(){

            @Override
            public State execute() {
                if (ValidateUserState.this.stateValues.isExistingDisabledUser() || ValidateUserState.this.stateValues.isExistingEnabledUser()) {
                    PromptNewUserState duplicateContinuing = ValidateUserState.this.stateValues.isSilentOrNonInteractive() ? null : new PromptNewUserState(ValidateUserState.this.theConsole, ValidateUserState.this.stateValues);
                    ValidateUserState.this.stateValues.setExistingUser(true);
                    if (ValidateUserState.this.stateValues.isSilentOrNonInteractive()) {
                        return ValidateUserState.this;
                    }
                    boolean existingDisabledUser = ValidateUserState.this.stateValues.isExistingDisabledUser();
                    if (existingDisabledUser) {
                        ValidateUserState.this.theConsole.printf(DomainManagementLogger.ROOT_LOGGER.aboutToUpdateDisabledUser(ValidateUserState.this.stateValues.getUserName()), new Object[0]);
                    } else {
                        ValidateUserState.this.theConsole.printf(DomainManagementLogger.ROOT_LOGGER.aboutToUpdateEnabledUser(ValidateUserState.this.stateValues.getUserName()), new Object[0]);
                    }
                    ValidateUserState.this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
                    String response = ValidateUserState.this.theConsole.readLine("(a): ", new Object[0]);
                    if (response == null) {
                        ValidateUserState.this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
                        return null;
                    }
                    Option option = ValidateUserState.this.convertResponse(response, existingDisabledUser);
                    switch (option) {
                        case NEW: {
                            return duplicateContinuing;
                        }
                        case UPDATE: {
                            break;
                        }
                        case ENABLE: {
                            ValidateUserState.this.stateValues.getOptions().setEnableDisableMode(true);
                            ValidateUserState.this.stateValues.getOptions().setDisable(false);
                            return new PreModificationState(ValidateUserState.this.theConsole, ValidateUserState.this.stateValues);
                        }
                        case DISABLE: {
                            ValidateUserState.this.stateValues.getOptions().setEnableDisableMode(true);
                            ValidateUserState.this.stateValues.getOptions().setDisable(true);
                            return new PreModificationState(ValidateUserState.this.theConsole, ValidateUserState.this.stateValues);
                        }
                        default: {
                            return new ErrorState(ValidateUserState.this.theConsole, DomainManagementLogger.ROOT_LOGGER.invalidChoiceUpdateUserResponse(), this, ValidateUserState.this.stateValues);
                        }
                    }
                    return ValidateUserState.this;
                }
                ValidateUserState.this.stateValues.setExistingUser(false);
                return ValidateUserState.this;
            }
        };
    }

    private State getCommonNamesCheckState() {
        return new State(){

            @Override
            public State execute() {
                if (!ValidateUserState.this.stateValues.isExistingUser() && !ValidateUserState.this.stateValues.isSilentOrNonInteractive()) {
                    for (String current : BAD_USER_NAMES) {
                        if (!current.equals(ValidateUserState.this.stateValues.getUserName().toLowerCase(Locale.ENGLISH))) continue;
                        String message = DomainManagementLogger.ROOT_LOGGER.usernameEasyToGuess(ValidateUserState.this.stateValues.getUserName());
                        String prompt = DomainManagementLogger.ROOT_LOGGER.sureToAddUser(ValidateUserState.this.stateValues.getUserName());
                        return new ConfirmationChoice(ValidateUserState.this.theConsole, message, prompt, (State)ValidateUserState.this, ValidateUserState.this.getRetryState());
                    }
                }
                return ValidateUserState.this;
            }
        };
    }

    private Option convertResponse(String response, boolean existingDisabledUser) {
        String responseLowerCase = response.toLowerCase(Locale.ENGLISH);
        if ("".equals(responseLowerCase) || "a".equals(responseLowerCase)) {
            return Option.UPDATE;
        }
        if ("b".equals(responseLowerCase)) {
            if (existingDisabledUser) {
                return Option.ENABLE;
            }
            return Option.DISABLE;
        }
        if ("c".equals(responseLowerCase)) {
            return Option.NEW;
        }
        return Option.INVALID;
    }

    static {
        char[] validPunctuation = new char[]{'.', '-', ',', '@', '/', '\\', '='};
        Arrays.sort(validPunctuation);
        VALID_PUNCTUATION = validPunctuation;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < VALID_PUNCTUATION.length; ++i) {
            sb.append("\"");
            sb.append(VALID_PUNCTUATION[i]);
            sb.append("\"");
            if (i >= VALID_PUNCTUATION.length - 1) continue;
            sb.append(", ");
        }
        VALID_SYMBOLS = sb.toString();
    }

    private static enum Option {
        UPDATE,
        DISABLE,
        ENABLE,
        NEW,
        INVALID;

    }
}

