/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.Serializer;

public class SerializerExternalizer<T>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final Serializer<T> serializer;

    public SerializerExternalizer(Class<T> targetClass, Serializer<T> serializer) {
        this.targetClass = targetClass;
        this.serializer = serializer;
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
        this.serializer.write(output, object);
    }

    public T readObject(ObjectInput input) throws IOException {
        return this.serializer.read(input);
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public OptionalInt size(T object) {
        return this.serializer.size(object);
    }
}

