/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.Field;
import org.wildfly.clustering.marshalling.protostream.FieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.PackedArrayMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Scalar;
import org.wildfly.clustering.marshalling.protostream.ScalarClass;
import org.wildfly.clustering.marshalling.protostream.ScalarFieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;
import org.wildfly.clustering.marshalling.protostream.TypedArrayMarshaller;
import org.wildfly.clustering.marshalling.protostream.TypedEnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.TypedObjectMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum AnyField implements Field<Object>
{
    ANY(Scalar.ANY),
    REFERENCE(new ScalarMarshaller<Integer>(){

        @Override
        public Integer readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readUInt32();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Integer value) throws IOException {
            writer.writeVarint32(value);
        }

        @Override
        public Class<? extends Integer> getJavaClass() {
            return Integer.class;
        }

        @Override
        public WireType getWireType() {
            return WireType.VARINT;
        }
    }),
    BOOLEAN(Scalar.BOOLEAN),
    BYTE(Scalar.BYTE),
    SHORT(Scalar.SHORT),
    INTEGER(Scalar.INTEGER),
    LONG(Scalar.LONG),
    FLOAT(Scalar.FLOAT),
    DOUBLE(Scalar.DOUBLE),
    CHARACTER(Scalar.CHARACTER),
    STRING(Scalar.STRING),
    IDENTIFIED_OBJECT(new TypedObjectMarshaller(ScalarClass.ID)),
    IDENTIFIED_ENUM(new TypedEnumMarshaller<E>(ScalarClass.ID)),
    IDENTIFIED_ARRAY(new TypedArrayMarshaller(ScalarClass.ID)),
    FIELD_ARRAY(new TypedArrayMarshaller(ScalarClass.FIELD)),
    NAMED_OBJECT(new TypedObjectMarshaller(ScalarClass.NAME)),
    NAMED_ENUM(new TypedEnumMarshaller<E>(ScalarClass.NAME)),
    NAMED_ARRAY(new TypedArrayMarshaller(ScalarClass.NAME)),
    BOOLEAN_ARRAY(new FieldMarshaller<boolean[]>(){

        @Override
        public boolean[] readFrom(ProtoStreamReader reader) throws IOException {
            byte[] bytes = (byte[])Scalar.BYTE_ARRAY.cast(byte[].class).readFrom(reader);
            int length = bytes.length;
            while (!reader.isAtEnd()) {
                int tag = reader.readTag();
                int index = WireType.getTagFieldNumber((int)tag);
                if (index == INTEGER.getIndex()) {
                    length = (bytes.length - 1) * 8 + reader.readUInt32();
                    continue;
                }
                reader.skipField(tag);
            }
            BitSet set = BitSet.valueOf(bytes);
            boolean[] values = new boolean[length];
            for (int i = 0; i < length; ++i) {
                values[i] = set.get(i);
            }
            return values;
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, boolean[] values) throws IOException {
            int length = values.length;
            BitSet set = new BitSet(length);
            for (int i = 0; i < length; ++i) {
                set.set(i, values[i]);
            }
            byte[] bytes = set.toByteArray();
            Scalar.BYTE_ARRAY.cast(byte[].class).writeTo(writer, bytes);
            int remainder = length % 8;
            if (remainder > 0) {
                writer.writeUInt32(INTEGER.getIndex(), remainder);
            }
        }

        @Override
        public Class<? extends boolean[]> getJavaClass() {
            return boolean[].class;
        }

        @Override
        public WireType getWireType() {
            return Scalar.BYTE_ARRAY.getWireType();
        }
    }),
    BYTE_ARRAY(Scalar.BYTE_ARRAY),
    SHORT_ARRAY(new PackedArrayMarshaller<Short>(Short.TYPE, Scalar.SHORT.cast(Short.class))),
    INTEGER_ARRAY(new PackedArrayMarshaller<Integer>(Integer.TYPE, Scalar.INTEGER.cast(Integer.class))),
    LONG_ARRAY(new PackedArrayMarshaller<Long>(Long.TYPE, Scalar.LONG.cast(Long.class))),
    FLOAT_ARRAY(new PackedArrayMarshaller<Float>(Float.TYPE, Scalar.FLOAT.cast(Float.class))),
    DOUBLE_ARRAY(new PackedArrayMarshaller<Double>(Double.TYPE, Scalar.DOUBLE.cast(Double.class))),
    CHAR_ARRAY(new PackedArrayMarshaller<Character>(Character.TYPE, Scalar.CHARACTER.cast(Character.class))),
    ANY_ARRAY(new TypedArrayMarshaller(ScalarClass.ANY)),
    PROXY(new FieldMarshaller<Object>(){

        @Override
        public Object readFrom(ProtoStreamReader reader) throws IOException {
            InvocationHandler handler = (InvocationHandler)Scalar.ANY.readFrom(reader);
            LinkedList interfaces = new LinkedList();
            while (!reader.isAtEnd()) {
                int tag = reader.readTag();
                int index = WireType.getTagFieldNumber((int)tag);
                if (index == ANY.getIndex()) {
                    interfaces.add(ScalarClass.ANY.readFrom(reader));
                    continue;
                }
                reader.skipField(tag);
            }
            return Proxy.newProxyInstance(WildFlySecurityManager.getClassLoaderPrivileged(handler.getClass()), interfaces.toArray(new Class[0]), handler);
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Object proxy) throws IOException {
            Scalar.ANY.writeTo(writer, Proxy.getInvocationHandler(proxy));
            for (Class<?> interfaceClass : proxy.getClass().getInterfaces()) {
                writer.writeTag(ANY.getIndex(), ScalarClass.ANY.getWireType());
                ScalarClass.ANY.writeTo(writer, interfaceClass);
            }
        }

        @Override
        public Class<? extends Object> getJavaClass() {
            return Object.class;
        }

        @Override
        public WireType getWireType() {
            return WireType.LENGTH_DELIMITED;
        }
    });

    private final FieldMarshaller<Object> marshaller;
    private static final AnyField[] VALUES;
    private static final Map<Class<?>, AnyField> FIELDS;

    private AnyField(ScalarMarshaller<?> marshaller) {
        this(new ScalarFieldMarshaller(marshaller));
    }

    private AnyField(FieldMarshaller<?> marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public int getIndex() {
        return this.ordinal() + 1;
    }

    @Override
    public FieldMarshaller<Object> getMarshaller() {
        return this.marshaller;
    }

    static AnyField fromIndex(int index) {
        return index > 0 && index <= VALUES.length ? VALUES[index - 1] : null;
    }

    static AnyField fromJavaType(Class<?> targetClass) {
        return FIELDS.get(targetClass);
    }

    static {
        VALUES = AnyField.values();
        FIELDS = new IdentityHashMap();
        for (AnyField field : VALUES) {
            Class fieldClass = field.getMarshaller().getJavaClass();
            if (fieldClass == Object.class || fieldClass == Enum.class || fieldClass == Class.class) continue;
            FIELDS.put(fieldClass, field);
        }
    }
}

