/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AllowListConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;

public class AllowListConfigurationBuilder
implements Builder<AllowListConfiguration> {
    private final AttributeSet attributes;
    private final Set<String> classes = new HashSet<String>();
    private final List<String> regexps = new ArrayList<String>();
    private final GlobalConfigurationBuilder globalBuilder;

    AllowListConfigurationBuilder(GlobalConfigurationBuilder globalBuilder) {
        this.globalBuilder = globalBuilder;
        this.attributes = AllowListConfiguration.attributeDefinitionSet();
    }

    public <T> AllowListConfigurationBuilder addClass(String clazz) {
        this.classes.add(clazz);
        return this;
    }

    public <T> AllowListConfigurationBuilder addClasses(Class ... classes) {
        List classNames = Arrays.stream(classes).map(Class::getName).collect(Collectors.toList());
        this.classes.addAll(classNames);
        return this;
    }

    public <T> AllowListConfigurationBuilder addRegexp(String regex) {
        this.regexps.add(regex);
        return this;
    }

    public <T> AllowListConfigurationBuilder addRegexps(String ... regexps) {
        this.regexps.addAll(Arrays.asList(regexps));
        return this;
    }

    public void validate() {
    }

    public AllowListConfiguration create() {
        if (!this.classes.isEmpty()) {
            this.attributes.attribute(AllowListConfiguration.CLASSES).set(this.classes);
        }
        if (!this.regexps.isEmpty()) {
            this.attributes.attribute(AllowListConfiguration.REGEXPS).set(this.regexps);
        }
        return new AllowListConfiguration(this.attributes.protect(), this.globalBuilder.getClassLoader());
    }

    public Builder<?> read(AllowListConfiguration template) {
        this.attributes.read(template.attributes());
        this.classes.addAll(template.getClasses());
        this.regexps.addAll(template.getRegexps());
        return this;
    }
}

