/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jberet._private.BatchMessages;

public final class ValueConverter {
    private static final String delimiter = ",";
    private static final int[] dateFormatCodes = new int[]{0, 1, 2, 3};

    public static Object convertInjectionValue(String rawValue, Class<?> t, AnnotatedElement f, ClassLoader classLoader) {
        Type genericType;
        Object result = ValueConverter.convertSingleValue(rawValue, t, f, classLoader);
        if (result != null) {
            return result;
        }
        String v = rawValue.trim();
        Class<?> elementValueType = null;
        if (t.isArray()) {
            elementValueType = t.getComponentType();
            if (elementValueType.isPrimitive()) {
                return ValueConverter.parsePrimitiveArray(v, elementValueType, f);
            }
            List tempList = ValueConverter.parseList(v, new ArrayList(), elementValueType, f, classLoader);
            Object[] tempArray = (Object[])Array.newInstance(elementValueType, tempList.size());
            return tempList.toArray(tempArray);
        }
        if (t == Properties.class) {
            Properties p = new Properties();
            return ValueConverter.parseMap(v, p, String.class, f, classLoader);
        }
        if (f instanceof Field && (genericType = ((Field)f).getGenericType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            Class[] elementTypes = new Class[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (!(actualTypeArguments[i] instanceof Class)) continue;
                elementTypes[i] = (Class)actualTypeArguments[i];
            }
            switch (elementTypes.length) {
                case 1: {
                    elementValueType = elementTypes[0];
                    break;
                }
                case 2: {
                    elementValueType = elementTypes[1];
                }
            }
        }
        if (elementValueType == null) {
            elementValueType = String.class;
        }
        if (List.class.isAssignableFrom(t) || t == Collection.class) {
            AbstractList l;
            if (t == List.class || t == ArrayList.class || t == Collection.class) {
                l = new ArrayList();
            } else if (t == LinkedList.class) {
                l = new LinkedList();
            } else if (t == Vector.class) {
                l = new Vector();
            } else {
                throw BatchMessages.MESSAGES.unsupportedInjectionType(v, f, t);
            }
            return ValueConverter.parseList(v, l, elementValueType, f, classLoader);
        }
        if (Map.class.isAssignableFrom(t)) {
            Map m;
            if (t == Map.class || t == HashMap.class) {
                m = new HashMap();
            } else if (t == LinkedHashMap.class) {
                m = new LinkedHashMap();
            } else if (t == IdentityHashMap.class) {
                m = new IdentityHashMap();
            } else if (t == Hashtable.class) {
                m = new Hashtable();
            } else if (t == TreeMap.class || t == SortedMap.class) {
                m = new TreeMap();
            } else if (t == WeakHashMap.class) {
                m = new WeakHashMap();
            } else {
                throw BatchMessages.MESSAGES.unsupportedInjectionType(v, f, t);
            }
            return ValueConverter.parseMap(v, m, elementValueType, f, classLoader);
        }
        if (Set.class.isAssignableFrom(t)) {
            AbstractSet set;
            if (t == Set.class || t == HashSet.class) {
                set = new HashSet();
            } else if (t == SortedSet.class || t == TreeSet.class) {
                set = new TreeSet();
            } else if (t == LinkedHashSet.class) {
                set = new LinkedHashSet();
            } else {
                throw BatchMessages.MESSAGES.unsupportedInjectionType(v, f, t);
            }
            set.addAll(ValueConverter.parseList(v, new ArrayList(), elementValueType, f, classLoader));
            return set;
        }
        throw BatchMessages.MESSAGES.unsupportedInjectionType(v, f, t);
    }

    private static Object convertSingleValue(String rawValue, Class<?> t, AnnotatedElement f, ClassLoader classLoader) {
        String v = rawValue.trim();
        if (t == Integer.TYPE || t == Integer.class) {
            return Integer.valueOf(v);
        }
        if (t == Long.TYPE || t == Long.class) {
            return Long.valueOf(v);
        }
        if (t == Double.TYPE || t == Double.class) {
            return Double.valueOf(v);
        }
        if (t == Boolean.TYPE || t == Boolean.class) {
            return Boolean.valueOf(v);
        }
        if (t == Float.TYPE || t == Float.class) {
            return Float.valueOf(v);
        }
        if (t == Character.TYPE || t == Character.class) {
            return Character.valueOf(rawValue.charAt(0));
        }
        if (t == Byte.TYPE || t == Byte.class) {
            return Byte.valueOf(v);
        }
        if (t == Short.TYPE || t == Short.class) {
            return Short.valueOf(v);
        }
        if (t == File.class) {
            return new File(v);
        }
        if (t == ZipFile.class) {
            try {
                return new ZipFile(v);
            }
            catch (IOException e) {
                throw BatchMessages.MESSAGES.failToInjectProperty(e, v, f);
            }
        }
        if (t == JarFile.class) {
            try {
                return new JarFile(v);
            }
            catch (IOException e) {
                throw BatchMessages.MESSAGES.failToInjectProperty(e, v, f);
            }
        }
        if (t == URL.class) {
            try {
                return new URI(v).toURL();
            }
            catch (Exception e) {
                throw BatchMessages.MESSAGES.failToInjectProperty(e, v, f);
            }
        }
        if (t == URI.class) {
            try {
                return new URI(v);
            }
            catch (Exception e) {
                throw BatchMessages.MESSAGES.failToInjectProperty(e, v, f);
            }
        }
        if (t == InetAddress.class || t == Inet4Address.class || t == Inet6Address.class) {
            try {
                return InetAddress.getByName(v);
            }
            catch (Exception e) {
                throw BatchMessages.MESSAGES.failToInjectProperty(e, v, f);
            }
        }
        if (t == BigDecimal.class) {
            return new BigDecimal(v);
        }
        if (t == BigInteger.class) {
            return new BigInteger(v);
        }
        if (t == Date.class) {
            return ValueConverter.parseDate(v, f);
        }
        if (t == Class.class) {
            try {
                return Class.forName(v, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw BatchMessages.MESSAGES.failToInjectProperty(e, v, f);
            }
        }
        if (t.isEnum()) {
            return Enum.valueOf(t, v);
        }
        if (t == Pattern.class) {
            return Pattern.compile(v);
        }
        if (t == Logger.class) {
            return Logger.getLogger(v);
        }
        if (t == StringBuilder.class) {
            return new StringBuilder(rawValue);
        }
        if (t == StringBuffer.class) {
            return new StringBuffer(rawValue);
        }
        if (t == ObjectName.class) {
            try {
                return new ObjectName(v);
            }
            catch (MalformedObjectNameException e) {
                throw BatchMessages.MESSAGES.failToInjectProperty(e, v, f);
            }
        }
        return null;
    }

    private static Object parsePrimitiveArray(String v, Class<?> primitiveType, AnnotatedElement f) {
        StringTokenizer st = new StringTokenizer(v, delimiter);
        int count = st.countTokens();
        String[] sVal = new String[count];
        for (int i = 0; i < count; ++i) {
            String s;
            sVal[i] = s = st.nextToken().trim();
        }
        if (primitiveType == Integer.TYPE) {
            int[] result = new int[count];
            for (int i = 0; i < count; ++i) {
                result[i] = Integer.parseInt(sVal[i]);
            }
            return result;
        }
        if (primitiveType == Long.TYPE) {
            long[] result = new long[count];
            for (int i = 0; i < count; ++i) {
                result[i] = Long.parseLong(sVal[i]);
            }
            return result;
        }
        if (primitiveType == Double.TYPE) {
            double[] result = new double[count];
            for (int i = 0; i < count; ++i) {
                result[i] = Double.parseDouble(sVal[i]);
            }
            return result;
        }
        if (primitiveType == Boolean.TYPE) {
            boolean[] result = new boolean[count];
            for (int i = 0; i < count; ++i) {
                result[i] = Boolean.parseBoolean(sVal[i]);
            }
            return result;
        }
        if (primitiveType == Float.TYPE) {
            float[] result = new float[count];
            for (int i = 0; i < count; ++i) {
                result[i] = Float.parseFloat(sVal[i]);
            }
            return result;
        }
        if (primitiveType == Character.TYPE) {
            char[] result = new char[count];
            for (int i = 0; i < count; ++i) {
                result[i] = sVal[i].charAt(0);
            }
            return result;
        }
        if (primitiveType == Byte.TYPE) {
            byte[] result = new byte[count];
            for (int i = 0; i < count; ++i) {
                result[i] = Byte.parseByte(sVal[i]);
            }
            return result;
        }
        if (primitiveType == Short.TYPE) {
            short[] result = new short[count];
            for (int i = 0; i < count; ++i) {
                result[i] = Short.parseShort(sVal[i]);
            }
            return result;
        }
        throw BatchMessages.MESSAGES.failToInjectProperty(null, v, f);
    }

    private static List parseList(String v, List l, Class<?> elementValueType, AnnotatedElement f, ClassLoader classLoader) {
        StringTokenizer st = new StringTokenizer(v, delimiter);
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (elementValueType.isAssignableFrom(String.class)) {
                l.add(s.equals("null") ? null : s);
                continue;
            }
            l.add(ValueConverter.convertSingleValue(s, elementValueType, f, classLoader));
        }
        return l;
    }

    private static Map parseMap(String v, Map map, Class<?> elementValueType, AnnotatedElement f, ClassLoader classLoader) {
        StringTokenizer st = new StringTokenizer(v, delimiter);
        while (st.hasMoreTokens()) {
            String value;
            String key;
            String pair = st.nextToken().trim();
            int i = pair.indexOf(61);
            if (i > 0) {
                key = pair.substring(0, i).trim();
                value = pair.substring(i + 1).trim();
            } else if (i < 0) {
                key = pair;
                value = null;
            } else {
                throw BatchMessages.MESSAGES.failToInjectProperty(null, v, f);
            }
            if (elementValueType == String.class) {
                map.put(key, value);
                continue;
            }
            map.put(key, ValueConverter.convertSingleValue(value, elementValueType, f, classLoader));
        }
        return map;
    }

    private static Date parseDate(String v, AnnotatedElement f) {
        DateFormat df;
        for (int p : dateFormatCodes) {
            df = DateFormat.getDateTimeInstance(p, p);
            df.setLenient(false);
            try {
                return df.parse(v);
            }
            catch (ParseException parseException) {
            }
        }
        for (int p : dateFormatCodes) {
            df = DateFormat.getDateInstance(p);
            df.setLenient(false);
            try {
                return df.parse(v);
            }
            catch (ParseException parseException) {
            }
        }
        throw BatchMessages.MESSAGES.failToInjectProperty(null, v, f);
    }
}

