/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaCloudEventMetadata;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.KafkaRecord;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.impl.ce.KafkaCloudEventHelper;
import io.smallrye.reactive.messaging.kafka.tracing.HeaderExtractAdapter;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class IncomingKafkaRecord<K, T>
implements KafkaRecord<K, T> {
    private Metadata metadata;
    private final io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata<K, T> kafkaMetadata;
    private final KafkaCommitHandler commitHandler;
    private final KafkaFailureHandler onNack;
    private final T payload;

    public IncomingKafkaRecord(ConsumerRecord<K, T> record, String channel, int index, KafkaCommitHandler commitHandler, KafkaFailureHandler onNack, boolean cloudEventEnabled, boolean tracingEnabled) {
        this.commitHandler = commitHandler;
        this.kafkaMetadata = new io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata(record, channel, index);
        IncomingKafkaRecordMetadata<K, T> deprecatedKafkaMetadata = new IncomingKafkaRecordMetadata<K, T>(record, channel, index);
        ArrayList<Object> meta = new ArrayList<Object>();
        meta.add(this.kafkaMetadata);
        meta.add(deprecatedKafkaMetadata);
        Object payload = null;
        boolean payloadSet = false;
        if (cloudEventEnabled) {
            KafkaCloudEventHelper.CloudEventMode mode = KafkaCloudEventHelper.getCloudEventMode(record);
            switch (mode) {
                case NOT_A_CLOUD_EVENT: {
                    break;
                }
                case STRUCTURED: {
                    IncomingKafkaCloudEventMetadata<K, T> event = KafkaCloudEventHelper.createFromStructuredCloudEvent(record);
                    meta.add(event);
                    payloadSet = true;
                    payload = event.getData();
                    break;
                }
                case BINARY: {
                    meta.add(KafkaCloudEventHelper.createFromBinaryCloudEvent(record));
                }
            }
        }
        if (tracingEnabled) {
            TracingMetadata tracingMetadata = TracingMetadata.empty();
            if (record.headers() != null) {
                Context context = GlobalOpenTelemetry.getPropagators().getTextMapPropagator().extract(Context.root(), (Object)this.kafkaMetadata.getHeaders(), (TextMapGetter)HeaderExtractAdapter.GETTER);
                tracingMetadata = TracingMetadata.withPrevious((Context)context);
            }
            meta.add(tracingMetadata);
        }
        this.metadata = ContextAwareMessage.captureContextMetadata(meta);
        this.onNack = onNack;
        this.payload = payload == null && !payloadSet ? record.value() : payload;
    }

    public T getPayload() {
        return this.payload;
    }

    @Override
    public K getKey() {
        return (K)this.kafkaMetadata.getKey();
    }

    @Override
    public String getTopic() {
        return this.kafkaMetadata.getTopic();
    }

    @Override
    public int getPartition() {
        return this.kafkaMetadata.getPartition();
    }

    @Override
    public Instant getTimestamp() {
        return this.kafkaMetadata.getTimestamp();
    }

    @Override
    public Headers getHeaders() {
        return this.kafkaMetadata.getHeaders();
    }

    public long getOffset() {
        return this.kafkaMetadata.getOffset();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((IncomingKafkaRecord)this).nack(arg_0);
    }

    public CompletionStage<Void> ack() {
        return this.commitHandler.handle(this).subscribeAsCompletionStage();
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return this.onNack.handle(this, reason, metadata).subscribeAsCompletionStage();
    }

    public synchronized void injectMetadata(Object metadata) {
        this.metadata = this.metadata.with(metadata);
    }
}

