/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.routing.infinispan;

import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.ServiceNameFactory;
import org.wildfly.clustering.infinispan.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.server.service.ProvidedCacheServiceConfigurator;
import org.wildfly.clustering.server.service.group.DistributedCacheGroupServiceConfiguratorProvider;
import org.wildfly.clustering.server.service.registry.DistributedRegistryServiceConfiguratorProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.extension.clustering.web.routing.LocalRouteServiceConfigurator;
import org.wildfly.extension.clustering.web.routing.infinispan.InfinispanRoutingConfiguration;
import org.wildfly.extension.clustering.web.routing.infinispan.RouteRegistryEntryProviderServiceConfigurator;

public class InfinispanRoutingProvider
implements RoutingProvider {
    private final InfinispanRoutingConfiguration config;

    public InfinispanRoutingProvider(InfinispanRoutingConfiguration config) {
        this.config = config;
    }

    public Iterable<CapabilityServiceConfigurator> getServiceConfigurators(String serverName, SupplierDependency<String> route) {
        String containerName = this.config.getContainerName();
        String cacheName = this.config.getCacheName();
        LocalRouteServiceConfigurator localRouteConfigurator = new LocalRouteServiceConfigurator(serverName, route);
        RouteRegistryEntryProviderServiceConfigurator registryEntryConfigurator = new RouteRegistryEntryProviderServiceConfigurator(containerName, serverName);
        TemplateConfigurationServiceConfigurator configurationConfigurator = new TemplateConfigurationServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CONFIGURATION.getName()).append(new String[]{containerName, serverName}), containerName, serverName, cacheName, (Consumer)this.config);
        CacheServiceConfigurator cacheConfigurator = new CacheServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CACHE.getName()).append(new String[]{containerName, serverName}), containerName, serverName);
        ProvidedCacheServiceConfigurator groupConfigurator = new ProvidedCacheServiceConfigurator(DistributedCacheGroupServiceConfiguratorProvider.class, containerName, serverName);
        ProvidedCacheServiceConfigurator registryConfigurator = new ProvidedCacheServiceConfigurator(DistributedRegistryServiceConfiguratorProvider.class, containerName, serverName);
        return List.of(localRouteConfigurator, registryEntryConfigurator, configurationConfigurator, cacheConfigurator, registryConfigurator, groupConfigurator);
    }
}

