/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.server.LiveNodeLocator;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.utils.ConcurrentUtil;
import org.jboss.logging.Logger;

public class NamedLiveNodeLocatorForScaleDown
extends LiveNodeLocator {
    private static final Logger logger = Logger.getLogger(NamedLiveNodeLocatorForScaleDown.class);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final String scaleDownGroupName;
    private final ActiveMQServerImpl server;
    Map<String, Pair<TransportConfiguration, TransportConfiguration>> connectors = new HashMap<String, Pair<TransportConfiguration, TransportConfiguration>>();
    private String nodeID;
    private String myNodeID;

    public NamedLiveNodeLocatorForScaleDown(String scaleDownGroupName, ActiveMQServerImpl server) {
        this.server = server;
        this.scaleDownGroupName = scaleDownGroupName;
        this.myNodeID = server.getNodeID().toString();
    }

    @Override
    public void locateNode() throws ActiveMQException {
        this.locateNode(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateNode(long timeout) throws ActiveMQException {
        block9: {
            try {
                this.lock.lock();
                if (!this.connectors.isEmpty()) break block9;
                try {
                    if (timeout != -1L) {
                        if (!ConcurrentUtil.await((Condition)this.condition, (long)timeout)) {
                            throw new ActiveMQException("Timeout elapsed while waiting for cluster node");
                        }
                    } else {
                        while (this.connectors.isEmpty()) {
                            this.condition.await();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        try {
            this.lock.lock();
            Pair connector = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
            if (topologyMember.getNodeId().equals(this.myNodeID)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(this + "::informing node about itself, nodeUUID=" + this.server.getNodeID() + ", connectorPair=" + topologyMember + ", this = " + this));
                }
                return;
            }
            if (this.scaleDownGroupName.equals(topologyMember.getScaleDownGroupName()) && topologyMember.getLive() != null && this.server.checkLiveIsNotColocated(topologyMember.getNodeId())) {
                this.connectors.put(topologyMember.getNodeId(), (Pair<TransportConfiguration, TransportConfiguration>)connector);
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeDown(long eventUID, String nodeID) {
        try {
            this.lock.lock();
            this.connectors.remove(nodeID);
            if (this.connectors.size() > 0) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration() {
        try {
            this.lock.lock();
            Iterator<String> iterator = this.connectors.keySet().iterator();
            if (iterator.hasNext()) {
                this.nodeID = iterator.next();
            }
            Pair<TransportConfiguration, TransportConfiguration> pair = this.connectors.get(this.nodeID);
            return pair;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        try {
            this.lock.lock();
            this.connectors.remove(this.nodeID);
        }
        finally {
            this.lock.unlock();
        }
    }
}

