/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsat.client;

import com.arjuna.webservices11.util.PrivilegedServiceFactory;
import com.arjuna.webservices11.util.PrivilegedServiceHelper;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.AddressingFeature;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.util.Map;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionCoordinatorPortType;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionCoordinatorRPCPortType;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionCoordinatorRPCService;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionCoordinatorService;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionInitiatorPortType;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionInitiatorService;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CoordinatorPortType;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CoordinatorService;
import org.oasis_open.docs.ws_tx.wsat._2006._06.ParticipantPortType;
import org.oasis_open.docs.ws_tx.wsat._2006._06.ParticipantService;

public class WSATClient {
    private static ThreadLocal<CoordinatorService> coordinatorService = new ThreadLocal();
    private static ThreadLocal<ParticipantService> participantService = new ThreadLocal();
    private static ThreadLocal<CompletionCoordinatorService> completionCoordinatorService = new ThreadLocal();
    private static ThreadLocal<CompletionInitiatorService> completionInitiatorService = new ThreadLocal();
    private static ThreadLocal<CompletionCoordinatorRPCService> completionCoordinatorRPCService = new ThreadLocal();

    private static synchronized CoordinatorService getCoordinatorService() {
        if (coordinatorService.get() == null) {
            coordinatorService.set(PrivilegedServiceFactory.getInstance(CoordinatorService.class).getService());
        }
        return coordinatorService.get();
    }

    private static synchronized ParticipantService getParticipantService() {
        if (participantService.get() == null) {
            participantService.set(PrivilegedServiceFactory.getInstance(ParticipantService.class).getService());
        }
        return participantService.get();
    }

    private static synchronized CompletionCoordinatorService getCompletionCoordinatorService() {
        if (completionCoordinatorService.get() == null) {
            completionCoordinatorService.set(PrivilegedServiceFactory.getInstance(CompletionCoordinatorService.class).getService());
        }
        return completionCoordinatorService.get();
    }

    private static synchronized CompletionInitiatorService getCompletionInitiatorService() {
        if (completionInitiatorService.get() == null) {
            completionInitiatorService.set(PrivilegedServiceFactory.getInstance(CompletionInitiatorService.class).getService());
        }
        return completionInitiatorService.get();
    }

    private static synchronized CompletionCoordinatorRPCService getCompletionCoordinatorRPCService() {
        if (completionCoordinatorRPCService.get() == null) {
            completionCoordinatorRPCService.set(PrivilegedServiceFactory.getInstance(CompletionCoordinatorRPCService.class).getService());
        }
        return completionCoordinatorRPCService.get();
    }

    public static CoordinatorPortType getCoordinatorPort(W3CEndpointReference endpointReference, String action, MAP map) {
        CoordinatorService service = WSATClient.getCoordinatorService();
        CoordinatorPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, (EndpointReference)endpointReference, CoordinatorPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        WSATClient.configureEndpointPort(bindingProvider, action, map);
        return port;
    }

    public static ParticipantPortType getParticipantPort(W3CEndpointReference endpointReference, String action, MAP map) {
        ParticipantService service = WSATClient.getParticipantService();
        ParticipantPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, (EndpointReference)endpointReference, ParticipantPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        WSATClient.configureEndpointPort(bindingProvider, action, map);
        return port;
    }

    public static CompletionCoordinatorPortType getCompletionCoordinatorPort(W3CEndpointReference endpointReference, String action, MAP map) {
        CompletionCoordinatorService service = WSATClient.getCompletionCoordinatorService();
        CompletionCoordinatorPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, (EndpointReference)endpointReference, CompletionCoordinatorPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        WSATClient.configureEndpointPort(bindingProvider, action, map);
        return port;
    }

    public static CompletionInitiatorPortType getCompletionInitiatorPort(W3CEndpointReference endpointReference, String action, MAP map) {
        CompletionInitiatorService service = WSATClient.getCompletionInitiatorService();
        CompletionInitiatorPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, (EndpointReference)endpointReference, CompletionInitiatorPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        WSATClient.configureEndpointPort(bindingProvider, action, map);
        return port;
    }

    public static CompletionCoordinatorRPCPortType getCompletionCoordinatorRPCPort(W3CEndpointReference endpointReference, String action, MAP map) {
        CompletionCoordinatorRPCService service = WSATClient.getCompletionCoordinatorRPCService();
        CompletionCoordinatorRPCPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, (EndpointReference)endpointReference, CompletionCoordinatorRPCPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        WSATClient.configureEndpointPort(bindingProvider, action, map);
        return port;
    }

    public static CoordinatorPortType getCoordinatorPort(String action, MAP map) {
        CoordinatorService service = WSATClient.getCoordinatorService();
        CoordinatorPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, CoordinatorPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        WSATClient.configurePort(bindingProvider, action, map);
        return port;
    }

    public static ParticipantPortType getParticipantPort(String action, MAP map) {
        ParticipantService service = WSATClient.getParticipantService();
        ParticipantPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, ParticipantPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        WSATClient.configurePort(bindingProvider, action, map);
        return port;
    }

    public static CompletionCoordinatorPortType getCompletionCoordinatorPort(String action, MAP map) {
        CompletionCoordinatorService service = WSATClient.getCompletionCoordinatorService();
        CompletionCoordinatorPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, CompletionCoordinatorPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        WSATClient.configurePort(bindingProvider, action, map);
        return port;
    }

    public static CompletionInitiatorPortType getCompletionInitiatorPort(String action, MAP map) {
        CompletionInitiatorService service = WSATClient.getCompletionInitiatorService();
        CompletionInitiatorPortType port = PrivilegedServiceHelper.getInstance().getPort((Service)service, CompletionInitiatorPortType.class, new WebServiceFeature[]{new AddressingFeature(true, true)});
        BindingProvider bindingProvider = (BindingProvider)port;
        WSATClient.configurePort(bindingProvider, action, map);
        return port;
    }

    private static void configureEndpointPort(BindingProvider bindingProvider, String action, MAP map) {
        Map requestContext = bindingProvider.getRequestContext();
        MAP requestMap = AddressingHelper.outboundMap(requestContext);
        map.setAction(action);
        AddressingHelper.installCallerProperties(map, requestMap);
        AddressingHelper.configureRequestContext(requestContext, requestMap.getTo(), action);
    }

    private static void configurePort(BindingProvider bindingProvider, String action, MAP map) {
        Map requestContext = bindingProvider.getRequestContext();
        map.setAction(action);
        AddressingHelper.configureRequestContext(requestContext, map, map.getTo(), action);
    }
}

