/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.facet.impl;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongIntScatterMap;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.PriorityQueue;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;

public class LongMultiValueFacetCounts
extends Facets {
    private final int[] counts = new int[1024];
    private final LongIntScatterMap hashCounts = new LongIntScatterMap();
    private final String field;
    private int totCount;

    public LongMultiValueFacetCounts(String field, LongMultiValuesSource valueSource, FacetsCollector hits) throws IOException {
        this.field = field;
        this.count(valueSource, hits.getMatchingDocs());
    }

    private void count(LongMultiValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongHashSet uniqueValuesForDocument = new LongHashSet();
        LongProcedure incrementCountForDocumentId = this::increment;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            LongMultiValues fv = valueSource.getValues(hits.context);
            DocIdSetIterator docs = hits.bits.iterator();
            int doc = docs.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fv.advanceExact(doc)) {
                    ++this.totCount;
                    while (fv.hasNextValue()) {
                        uniqueValuesForDocument.add(fv.nextValue());
                    }
                    uniqueValuesForDocument.forEach(incrementCountForDocumentId);
                    uniqueValuesForDocument.clear();
                }
                doc = docs.nextDoc();
            }
        }
    }

    private void increment(long value) {
        if (value >= 0L && value < (long)this.counts.length) {
            int n = (int)value;
            this.counts[n] = this.counts[n] + 1;
        } else {
            this.hashCounts.addTo(value, 1);
        }
    }

    public FacetResult getTopChildren(int topN, String dim, String ... path) {
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
        return this.getTopChildrenSortByCount(topN);
    }

    public FacetResult getTopChildrenSortByCount(int topN) {
        PriorityQueue<Entry> pq = new PriorityQueue<Entry>(Math.min(topN, this.counts.length + this.hashCounts.size())){

            protected boolean lessThan(Entry a, Entry b) {
                return a.count < b.count || a.count == b.count && a.value > b.value;
            }
        };
        int childCount = 0;
        Entry e = null;
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            ++childCount;
            if (e == null) {
                e = new Entry();
            }
            e.value = i;
            e.count = this.counts[i];
            e = (Entry)pq.insertWithOverflow((Object)e);
        }
        if (this.hashCounts.size() != 0) {
            childCount += this.hashCounts.size();
            for (LongIntCursor c : this.hashCounts) {
                int count = c.value;
                if (count == 0) continue;
                e = this.insertEntry(pq, e, c, count);
            }
        }
        LabelAndValue[] results = new LabelAndValue[pq.size()];
        while (pq.size() != 0) {
            Entry entry = (Entry)pq.pop();
            results[pq.size()] = new LabelAndValue(Long.toString(entry.value), (Number)entry.count);
        }
        return new FacetResult(this.field, new String[0], (Number)this.totCount, results, childCount);
    }

    private Entry insertEntry(PriorityQueue<Entry> pq, Entry e, LongIntCursor c, int count) {
        if (e == null) {
            e = new Entry();
        }
        e.value = c.key;
        e.count = count;
        e = (Entry)pq.insertWithOverflow((Object)e);
        return e;
    }

    public Number getSpecificValue(String dim, String ... path) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<FacetResult> getAllDims(int topN) throws IOException {
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LongValueFacetCounts totCount=");
        b.append(this.totCount);
        b.append(":\n");
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            b.append("  ");
            b.append(i);
            b.append(" -> count=");
            b.append(this.counts[i]);
            b.append('\n');
        }
        if (this.hashCounts.size() != 0) {
            for (LongIntCursor c : this.hashCounts) {
                if (c.value == 0) continue;
                b.append("  ");
                b.append(c.key);
                b.append(" -> count=");
                b.append(c.value);
                b.append('\n');
            }
        }
        return b.toString();
    }

    private static class Entry {
        int count;
        long value;

        private Entry() {
        }
    }
}

