/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.component.ServerLogsTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

public class ServerLogsTableModel
extends AbstractTableModel {
    private static final char[] SIZE_CHARS = new char[]{'K', 'M', 'G', 'T', 'P', 'E'};
    private CliGuiContext cliGuiCtx;
    private List<ModelNode> allLogs;
    private ServerLogsTable table;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final TableCellRenderer dateRenderer = new DefaultTableCellRenderer(){

        @Override
        protected void setValue(Object value) {
            DateFormat formatter = DateFormat.getDateTimeInstance();
            this.setText(value == null ? "" : formatter.format(value));
        }
    };
    private final DefaultTableCellRenderer sizeRenderer = new DefaultTableCellRenderer(){

        @Override
        protected void setValue(Object value) {
            Object result;
            if (value instanceof Long) {
                long len = (Long)value;
                int unit = 1000;
                if (len < 1000L) {
                    result = len + "B";
                } else {
                    int exp = (int)(Math.log(len) / Math.log(1000.0));
                    result = String.format("%.1f %sB", (double)len / Math.pow(1000.0, exp), Character.valueOf(SIZE_CHARS[exp - 1]));
                }
            } else {
                result = "";
            }
            this.setText((String)result);
        }
    };
    protected final String[] colNames = new String[]{"File", "Last Modified", "Size"};

    public ServerLogsTableModel(CliGuiContext cliGuiCtx, ServerLogsTable table) {
        this.cliGuiCtx = cliGuiCtx;
        this.table = table;
        this.sizeRenderer.setHorizontalAlignment(4);
    }

    private void init() {
        if (this.initialized.compareAndSet(false, true)) {
            RowSorter<? extends TableModel> rowSorter = this.table.getRowSorter();
            rowSorter.toggleSortOrder(1);
            rowSorter.toggleSortOrder(1);
            TableColumnModel columnModel = this.table.getColumnModel();
            columnModel.getColumn(1).setCellRenderer(this.dateRenderer);
            columnModel.getColumn(2).setCellRenderer(this.sizeRenderer);
        }
    }

    public void refresh() {
        try {
            this.init();
            this.allLogs = this.getLogFiles();
            this.fireTableDataChanged();
            if (!this.allLogs.isEmpty()) {
                this.table.setRowSelectionInterval(0, 0);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getRowCount() {
        if (this.allLogs == null) {
            return 0;
        }
        return this.allLogs.size();
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModelNode row = this.allLogs.get(rowIndex);
        if (columnIndex == 0) {
            return row.get("file-name").asString();
        }
        if (columnIndex == 1) {
            return new Date(row.get("last-modified-time").asLong());
        }
        if (columnIndex == 2) {
            return row.get("file-size").asLong();
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return this.colNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return Date.class;
        }
        if (columnIndex == 2) {
            return Long.class;
        }
        return String.class;
    }

    private List<ModelNode> getLogFiles() throws IOException {
        ModelControllerClient client = this.cliGuiCtx.getCommmandContext().getModelControllerClient();
        ModelNode address = new ModelNode().setEmptyList();
        address.add("subsystem", "logging");
        ModelNode op = Operations.createOperation("read-children-names", address);
        op.get("child-type").set("log-file");
        ModelNode response = client.execute(op);
        if (Operations.isSuccessfulOutcome(response)) {
            ModelNode result = Operations.readResult(response);
            ArrayList<String> files = new ArrayList<String>();
            Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
            for (ModelNode file : result.asList()) {
                files.add(file.asString());
                builder.addStep(Operations.createReadAttributeOperation(address.clone().add("log-file", file.asString()), "file-size")).addStep(Operations.createReadAttributeOperation(address.clone().add("log-file", file.asString()), "last-modified-time"));
            }
            result = client.execute(builder.build());
            ModelNode fileListing = new ModelNode().setEmptyList();
            if (Operations.isSuccessfulOutcome(result)) {
                List<ModelNode> attributes = Operations.readResult(result).asList();
                int i = 0;
                if (attributes.size() != files.size() * 2) {
                    throw new IllegalStateException("Error occurred reading the file attributes");
                }
                for (String file : files) {
                    ModelNode node = new ModelNode();
                    node.get("file-name").set(file);
                    node.get("file-size").set(Operations.readResult(attributes.get(i++).get(0)));
                    node.get("last-modified-time").set(Operations.readResult(attributes.get(i++).get(0)));
                    fileListing.add(node);
                }
            }
            return fileListing.asList();
        }
        throw new RuntimeException(Operations.getFailureDescription(response).asString());
    }
}

