/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.wildfly.clustering.context.ContextualExecutorService;
import org.wildfly.clustering.context.DefaultContextualizerFactory;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.security.ParametricPrivilegedAction;

public class DefaultExecutorService
extends ContextualExecutorService {
    public static final ParametricPrivilegedAction<Void, ExecutorService> SHUTDOWN_ACTION = new ParametricPrivilegedAction<Void, ExecutorService>(){

        public Void run(ExecutorService executor) {
            executor.shutdown();
            return null;
        }
    };
    public static final ParametricPrivilegedAction<List<Runnable>, ExecutorService> SHUTDOWN_NOW_ACTION = new ParametricPrivilegedAction<List<Runnable>, ExecutorService>(){

        public List<Runnable> run(ExecutorService executor) {
            return executor.shutdownNow();
        }
    };

    public DefaultExecutorService(Class<?> targetClass, Function<ThreadFactory, ExecutorService> factory) {
        super(factory.apply(new DefaultThreadFactory(targetClass)), DefaultContextualizerFactory.INSTANCE.createContextualizer(targetClass));
    }
}

