/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.servlet.api.Deployment;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.undertow.session.DistributableImmutableSession;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class UndertowSessionExpirationListener
implements SessionExpirationListener {
    private final Deployment deployment;
    private final SessionListeners listeners;
    private final Recordable<ImmutableSessionMetaData> recorder;

    public UndertowSessionExpirationListener(Deployment deployment, SessionListeners listeners, Recordable<ImmutableSessionMetaData> recorder) {
        this.deployment = deployment;
        this.listeners = listeners;
        this.recorder = recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionExpired(ImmutableSession session) {
        if (this.recorder != null) {
            this.recorder.record((Object)session.getMetaData());
        }
        UndertowSessionManager manager = (UndertowSessionManager)this.deployment.getSessionManager();
        DistributableImmutableSession undertowSession = new DistributableImmutableSession(manager, session);
        Batcher batcher = manager.getSessionManager().getBatcher();
        Batch batch = batcher.suspendBatch();
        try {
            this.listeners.sessionDestroyed((Session)undertowSession, null, SessionListener.SessionDestroyedReason.TIMEOUT);
        }
        finally {
            batcher.resumeBatch(batch);
        }
        ImmutableSessionAttributes attributes = session.getAttributes();
        for (String name : attributes.getAttributeNames()) {
            Object value = attributes.getAttribute(name);
            manager.getSessionListeners().attributeRemoved((Session)undertowSession, name, value);
        }
    }
}

