/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v60.impl;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.v60.impl.AbstractAccess;
import org.infinispan.hibernate.cache.v60.impl.DomainDataRegionImpl;

public class CollectionDataAccessImpl
extends AbstractAccess
implements CollectionDataAccess {
    public CollectionDataAccessImpl(DomainDataRegionImpl region, AccessDelegate delegate, AccessType accessType) {
        super(accessType, delegate, region);
    }

    public Object get(SharedSessionContractImplementor session, Object key) {
        return this.delegate.get((Object)session, key, session.getTransactionStartTimestamp());
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        return this.delegate.putFromLoad((Object)session, key, value, session.getTransactionStartTimestamp(), version);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version, boolean minimalPutOverride) {
        return this.delegate.putFromLoad((Object)session, key, value, session.getTransactionStartTimestamp(), version, minimalPutOverride);
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        this.delegate.remove((Object)session, key);
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        this.delegate.unlockItem((Object)session, key);
    }

    public Object generateCacheKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getCacheKeysFactory().createCollectionKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getCacheKeysFactory().getCollectionId(cacheKey);
    }
}

